package com.bizunited.nebula.mars.sdk.dto;

import java.util.Set;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 特定数据权限的设定方式
 * @author yinwenjie
 */
@ApiModel(value = "MarsAuthorityDto", description = "数据传输对象——特定数据权限的设定方式")
public class MarsAuthorityDto {
  /**
   * 修改数据时，可能使用的id信息
   */
  private String id;
  /**
   * 租户编号
   */
  private String tenantCode;
  /**
   * 系统唯一的数据权限设定编号
   */
  private String code;
  /**
   * mars数据权限设定的中文名
   */
  private String name;
  /**
   * 数据权限绑定的“选择范围key”信息
   */
  private String scopeKey;
  /**
   * 是否是这个列表默认的数据权限配置
   */
  private Boolean defaultScope = false;
  /**
   * 数据权限范围已选定的业务code，例如按照角色信息范围进行选择时的角色code；或者按照职位信息范围进行选择时的职位code；
   * 例如按照角色信息范围进行选择时的角色值“ADMIN”.....
   */
  @ApiModelProperty(name="scopeValues" , value = "数据权限范围已选定的业务code，例如按照角色信息范围进行选择时的角色code；或者按照职位信息范围进行选择时的职位code；")
  private String[] scopeValues;
  
  @ApiModelProperty(name="scopeNames" , value = "数据权限范围已选定的业务信息值的参考中文意义")
  private String[] scopeNames;
  /**
   * 数据权限绑定的菜单功能(全系统唯一)
   */
  private String competenceCode;
  /**
   * 数据权限参考的菜单名（参考值，可有可无）
   */
  private String competenceName;
  /**
   * 数据权限绑定的列表项(全系统唯一)
   */
  private String listCode;
  /**
   * 数据权限绑定的列表名（参考值，可有可无）
   */
  private String listName;
  /**
   * 该数据权限已选定的具体数据权限项目
   */
  private Set<MarsAuthorityDetailDto> marsSelectDetails;
  /**
   * 该数据权限设定中，已被排除显示的字段编号信息
   */
  private Set<MarsAuthorityExcludedFieldDetailDto> excludedFieldDetails;
  
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getScopeKey() {
    return scopeKey;
  }
  public void setScopeKey(String scopeKey) {
    this.scopeKey = scopeKey;
  }
  public String getCompetenceCode() {
    return competenceCode;
  }
  public void setCompetenceCode(String competenceCode) {
    this.competenceCode = competenceCode;
  }
  public String getListCode() {
    return listCode;
  }
  public void setListCode(String listCode) {
    this.listCode = listCode;
  }
  public String getCompetenceName() {
    return competenceName;
  }
  public void setCompetenceName(String competenceName) {
    this.competenceName = competenceName;
  }
  public String getListName() {
    return listName;
  }
  public void setListName(String listName) {
    this.listName = listName;
  }
  public String[] getScopeValues() {
    return scopeValues;
  }
  public void setScopeValues(String[] scopeValues) {
    this.scopeValues = scopeValues;
  }
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }
  public String getTenantCode() {
    return tenantCode;
  }
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
  public Set<MarsAuthorityDetailDto> getMarsSelectDetails() {
    return marsSelectDetails;
  }
  public void setMarsSelectDetails(Set<MarsAuthorityDetailDto> marsSelectDetails) {
    this.marsSelectDetails = marsSelectDetails;
  }
  public Set<MarsAuthorityExcludedFieldDetailDto> getExcludedFieldDetails() {
    return excludedFieldDetails;
  }
  public void setExcludedFieldDetails(Set<MarsAuthorityExcludedFieldDetailDto> excludedFieldDetails) {
    this.excludedFieldDetails = excludedFieldDetails;
  }
  public Boolean getDefaultScope() {
    return defaultScope;
  }
  public void setDefaultScope(Boolean defaultScope) {
    this.defaultScope = defaultScope;
  }
  public String[] getScopeNames() {
    return scopeNames;
  }
  public void setScopeNames(String[] scopeNames) {
    this.scopeNames = scopeNames;
  }
}
