package com.bizunited.nebula.mars.sdk.event;

import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;

/**
 * @author ning.zhang
 * @description 数据权限相关的事件通知
 * @date 2023/10/17
 */
public interface MarsAuthorityEventListener {

  /**
   * 当数据权限创建时，该事件被触发
   *
   * @param marsAuthority 新增数据权限信息
   */
  void onCreated(MarsAuthority marsAuthority);

  /**
   * 当数据权限被修改时，该事件被触发
   *
   * @param oldMarsAuthority 修改前数据权限信息
   * @param newMarsAuthority 修改后数据权限信息
   */
  void onUpdate(MarsAuthority oldMarsAuthority, MarsAuthority newMarsAuthority);

  /**
   * 当数据权限被删除时，该事件被触发
   *
   * @param marsAuthority 被删除数据权限信息
   */
  void onDeleted(MarsAuthority marsAuthority);

  /**
   * 当数据权限被启用时，该事件被触发
   *
   * @param oldMarsAuthority 启用前数据权限信息
   * @param newMarsAuthority 启用后数据权限信息
   */
  void onEffective(MarsAuthority oldMarsAuthority, MarsAuthority newMarsAuthority);

  /**
   * 当数据权限被禁用时，该事件被触发
   *
   * @param oldMarsAuthority 禁用前数据权限信息
   * @param newMarsAuthority 禁用后数据权限信息
   */
  void onInvalid(MarsAuthority oldMarsAuthority, MarsAuthority newMarsAuthority);
}
