package com.bizunited.nebula.mars.sdk.event;

import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;

/**
 * @author ning.zhang
 * @description 数据权限连接表达式相关的事件通知
 * @date 2023/10/17
 */
public interface MarsAuthorityExpressionEventListener {

  /**
   * 当数据权连接表达式限创建时，该事件被触发
   *
   * @param marsAuthorityExpression 新增数据权限连接表达式信息
   */
  void onCreated(MarsAuthorityExpressionVo marsAuthorityExpression);

  /**
   * 当数据权限连接表达式被修改时，该事件被触发
   *
   * @param oldMarsAuthorityExpression 修改前数据权限连接表达式信息
   * @param newMarsAuthorityExpression 修改后数据权限连接表达式信息
   */
  void onUpdate(MarsAuthorityExpressionVo oldMarsAuthorityExpression, MarsAuthorityExpressionVo newMarsAuthorityExpression);
}
