package com.bizunited.nebula.mars.sdk.register;

import com.bizunited.nebula.security.sdk.login.UserIdentity;

/**
 * 按照某个维度提供数据授权时，都可以有多种授权方式。
 * 例如，按照角色维度分组进行授权时，可以按照客户组来指定具体的角色，也可以直接指定为管理员角色等等，</br>
 * 那么，每一个SelectAuthorityModeRegister都是某个具体维度分组下，一个具体的选择方式。
 * @author yinwenjie
 */
public interface SelectAuthorityModeRegister {
  /**
   * 选择方式在系统中唯一的key字符串信息
   */
  public String modeKey();
  
  /**
   * 选择方式在显示页面上的中文描述，例如：查询固定渠道的客户
   */
  public String modeName();
  /**
   * 该选择方式使用的前端控件标识。这个标识对于后端服务来说没有太大意义。甚至可以为null（标识该选择项不使用任何前端控件）</br>
   * 但是该标识，对于页面来说非常重要，这样前端页面才知道，用什么控件显示出来给操作者选择信息。
   * @return
   */
  public String controlKey();
  /**
   * 该选择方式在维度分组中的排列顺序，值越小排在越前面
   * @return
   */
  public int sort();
  /**
   * 这个注册的维度选择项所属的维度分组的业务编号
   * @return
   */
  public String groupCode();
  /**
   * 返回值是否是一个数组
   * @return
   */
  public boolean isArrayValue();
  /**
   * 该属性主要表达，当前具体的数据权限选择项，其数值的来源形式</br>
   * 为true：表示当前数据权限选择项的值来源为一个固定值，例如在数据权限设定页面，通过下拉框选定的固定值</br>
   * 为false：表示当前数据权限选择项的值，是根据当前操作者的不同而不同，是一个动态值。例如根据当前登录人的岗位code，来确定值
   * @return 注意，如果当前方法返回false的时候，那么在数据权限查询命中当前选择项的时候，该选择项的dynamicValue方法会被触发
   * 触发后，将要求本注册器，按照modeValueClass方法设定的值的类型，进行动态值的返回
   */
  public boolean isStaticValue();
  /**
   * 选择信息的值类型，String、Integer、BigDecimal、Date等常用类型，mars数据权限子系统是可以自动转换的；但如果是其它值类型，
   * 那么需要二次开发的程序员自行实现MarsAuthorityValueAstConverter接口。
   * @return
   */
  public Class<?> modeValueClass();
  /**
   * 如果当前数据权限选择项的数值来源是“static”性质（也就是说isStaticValue方法返回的是true），那么该方法将在数据权限命中本选择项时，被触发。
   * @param staticValue 存储在数据持久层的静态数值，都会以数组进行传入，如果isArrayValue()为false，那么这里的数组长度为1
   * @return 注意，返回值必须按照设定的modeValueClass类型进行类型匹配，且返回的值也需要与isArrayValue的返回状态进行匹配
   */
  public Object staticValue(String[] staticValues);
  /**
   * 如果当前数据权限选择项的数值来源是“dynamic”性质（也就是说isStaticValue方法返回的是false），
   * 那么该方法将在数据权限命中本选择项时，被触发。用于根据当前登录者情况，或者业务系统状态，向mars核心过程返回一个动态的条件值。
   * @param loginDetails 当前登录者信息
   * @param modeGroupCode 当前数据权限选择项所属的“分组”业务编号
   * @return 注意，返回值必须按照设定的modeValueClass类型进行类型匹配，且返回的值也需要与isArrayValue的返回状态进行匹配
   */
  public Object dynamicValue(UserIdentity loginDetails , String modeGroupCode);
  
  // ====== 以下是该数据权限选项使用的SQL-AST转换器（具体参见MarsAuthorityValueAstConverter中的说明）
  
  /**
   * 该数据权限选择项使用的值-AST NODE转换器的key信息</br>
   * （注意，该key信息对应的MarsAuthorityAstConverter接口的实现必须存在）
   * @return
   */
  public String converterKey();
  
}
