package com.bizunited.nebula.mars.sdk.service;

import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExpressionVo;

/**
 * 和针对特定listCode的，多个数据权限的连接表达式服务层功能
 * @author yinwenjie
 */
public interface MarsAuthorityExpressionService {
  /**
   * 根据指定的listCode，查询它的表达式</br>
   * 注意，由于版本继承的关系，一个listCode对应的列表可能设定了数据权限，但是这里并没有表单式信息
   * @param listCode 列表页面编号
   */
  public MarsAuthorityExpressionVo findByListCode(String listCode);
  
  /**
   * 为指定listCode（列表控件）创建一个多个相关数据权限设定的组合公式
   * @param marsAuthorityExpression
   */
  public MarsAuthorityExpressionVo create(MarsAuthorityExpressionVo marsAuthorityExpression);
  
  /**
   * 为指定listCode（列表控件）修改多个相关数据权限设定的组合公式
   * @param marsAuthorityExpression
   */
  public void update(MarsAuthorityExpressionVo marsAuthorityExpression);
}
