package com.bizunited.nebula.mars.sdk.utils;

import java.sql.SQLSyntaxErrorException;
import java.util.List;

import org.apache.ibatis.mapping.BoundSql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;

/**
 * TODO 注释未写
 * @author yinwenjie
 */
public class MarsMybatisSqlUtils {
  private MarsMybatisSqlUtils() {
    
  }
  
  /**
   * 将原始sql格式化
   * @param boundSql
   * @return
   */
  public static String formatSql(BoundSql boundSql) {
    String sql = boundSql.getSql();
    sql = sql.trim();
    sql = sql.toLowerCase();
    sql = sql.replaceAll("`", "");
    sql = sql.replaceAll("\\s{1,}", " ");
    return sql;
  }
  
  /**
   * 使用druid的AST工具，将特定的SQL转换成特定数据库支持SQL会话
   * @param sql
   * @param dbType
   * @return
   * @throws SQLSyntaxErrorException
   */
  public static SQLStatement parser(String sql, String dbType) throws SQLSyntaxErrorException {
    List<SQLStatement> list = SQLUtils.parseStatements(sql, dbType);
    if (list.size() > 1) {
      throw new SQLSyntaxErrorException("MultiQueries is not supported,use single query instead ");
    }
    return list.get(0);
  }
}
