package com.bizunited.nebula.mars.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;

/**
 * 特定数据权限的设定方式
 * @author yinwenjie
 */
public class MarsAuthority extends TenantOpVo {
  private static final long serialVersionUID = -2543792029958601658L;
  /**
   * 系统唯一的数据权限设定编号
   */
  private String code;
  /**
   * mars数据权限设定的中文名
   */
  private String name;
  /**
   * 数据权限绑定的“选择范围key”信息
   */
  private String scopeKey;
  /**
   * 是否是这个列表默认的数据权限配置
   */
  private Boolean defaultScope = false;
  /**
   * 数据权限范围已选定的业务code，例如按照角色信息范围进行选择时的角色code；或者按照职位信息范围进行选择时的职位code；
   * 例如按照角色信息范围进行选择时的角色值“ADMIN”.....
   */
  @ApiModelProperty(name="scopeValues" , value = "数据权限范围已选定的业务code，例如按照角色信息范围进行选择时的角色code；或者按照职位信息范围进行选择时的职位code；")
  private String[] scopeValues;
  
  @ApiModelProperty(name="scopeNames" , value = "数据权限范围已选定的业务信息值的参考中文意义")
  private String[] scopeNames;
  /**
   * 数据权限绑定的菜单功能(全系统唯一)
   */
  private String competenceCode;
  /**
   * 数据权限参考的菜单名（参考值，可有可无）
   */
  private String competenceName;
  /**
   * 数据权限绑定的列表项(全系统唯一)
   */
  private String listCode;
  /**
   * 数据权限绑定的列表名（参考值，可有可无）
   */
  private String listName;
  /**
   * 设定状态：0：禁用/废弃；1：正常
   */
  private Integer status;
  /**
   * 该数据权限已选定的具体数据权限项目
   */
  private Set<MarsAuthorityDetail> marsSelectDetails;
  /**
   * 该数据权限设定中，已被排除显示的字段编号信息
   */
  private Set<MarsAuthorityExcludedFieldDetail> excludedFieldDetails;
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getScopeKey() {
    return scopeKey;
  }
  public void setScopeKey(String scopeKey) {
    this.scopeKey = scopeKey;
  }
  public String getCompetenceCode() {
    return competenceCode;
  }
  public void setCompetenceCode(String competenceCode) {
    this.competenceCode = competenceCode;
  }
  public String getListCode() {
    return listCode;
  }
  public void setListCode(String listCode) {
    this.listCode = listCode;
  }
  public Integer getStatus() {
    return status;
  }
  public void setStatus(Integer status) {
    this.status = status;
  }
  public Set<MarsAuthorityDetail> getMarsSelectDetails() {
    return marsSelectDetails;
  }
  public void setMarsSelectDetails(Set<MarsAuthorityDetail> marsSelectDetails) {
    this.marsSelectDetails = marsSelectDetails;
  }
  public String[] getScopeValues() {
    return scopeValues;
  }
  public void setScopeValues(String[] scopeValues) {
    this.scopeValues = scopeValues;
  }
  public String getCompetenceName() {
    return competenceName;
  }
  public void setCompetenceName(String competenceName) {
    this.competenceName = competenceName;
  }
  public String getListName() {
    return listName;
  }
  public void setListName(String listName) {
    this.listName = listName;
  }
  public Boolean getDefaultScope() {
    return defaultScope;
  }
  public void setDefaultScope(Boolean defaultScope) {
    this.defaultScope = defaultScope;
  }
  public String[] getScopeNames() {
    return scopeNames;
  }
  public void setScopeNames(String[] scopeNames) {
    this.scopeNames = scopeNames;
  }

  public Set<MarsAuthorityExcludedFieldDetail> getExcludedFieldDetails() {
    return excludedFieldDetails;
  }

  public void setExcludedFieldDetails(
      Set<MarsAuthorityExcludedFieldDetail> excludedFieldDetails) {
    this.excludedFieldDetails = excludedFieldDetails;
  }
}
