package com.bizunited.nebula.mars.sdk.vo;

import com.bizunited.nebula.common.vo.UuidVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "MarsAuthorityExcludedFieldDetail", description = "某个数据权限设定中已被排除显示的字段信息")
public class MarsAuthorityExcludedFieldDetail extends UuidVo {
  private static final long serialVersionUID = 8557181985389505694L;

  @ApiModelProperty(name="marsAuthorityId" , value="对应的数据权限设定编号", required=true)
  private String marsAuthorityId;
  
  @ApiModelProperty(name="excludedField" , value = "已被排除显示的字段业务编号")
  private String excludedField;

  @ApiModelProperty(name="excludedFieldName" , value = "参考的中文，可以有也可以没有，主要就是用来做显示")
  private String excludedFieldName;

  public String getMarsAuthorityId() {
    return marsAuthorityId;
  }
  public void setMarsAuthorityId(String marsAuthorityId) {
    this.marsAuthorityId = marsAuthorityId;
  }
  public String getExcludedField() {
    return excludedField;
  }
  public void setExcludedField(String excludedField) {
    this.excludedField = excludedField;
  }
  public String getExcludedFieldName() {
    return excludedFieldName;
  }
  public void setExcludedFieldName(String excludedFieldName) {
    this.excludedFieldName = excludedFieldName;
  }
}
