package com.bizunited.nebula.mars.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;

import io.swagger.annotations.ApiModelProperty;

/**
 * 针对一个listCode设定的多个数据权限，在进行执行时的连接表达式（服务层）
 * @author yinwenjie
 */
public class MarsAuthorityExpressionVo extends TenantOpVo {
  private static final long serialVersionUID = -8129220646846811886L;
  /**
   * 数据权限绑定的列表项(全系统唯一)
   */
  @ApiModelProperty(name="listCode" , value = "数据权限绑定的列表页面项(全系统唯一)")
  private String listCode;
  /**
   * 数据权限具体的表达式(当expressionType为3时)，例如：数据权限具体的表达式，例如：([Authority_code1] AND [Authority_code2]) OR ([Authority_code3] AND [Authority_code4])，Authority_code就是engine_mars_authority数据表中具有唯一特性的code信息
   */
  @ApiModelProperty(name="expression" , value = "数据权限具体的表达式，例如：数据权限具体的表达式，例如：([Authority_code1] AND [Authority_code2]) OR ([Authority_code3] AND [Authority_code4])，Authority_code就是engine_mars_authority数据表中具有唯一特性的code信息")
  private String expression;
  /**
   * 数据权限表达公式类型 1：全部求交集（AND）2：全部求并集（OR） 3：自定义公式
   */
  @ApiModelProperty(name="expressionType" , value = "数据权限表达公式类型 1：全部求交集（AND）2：全部求并集（OR） 3：自定义公式")
  private Integer expressionType;

  @ApiModelProperty(name="marsAuthorityId" , value = "数据权限ID")
  private String marsAuthorityId;
  
  public String getListCode() {
    return listCode;
  }
  public void setListCode(String listCode) {
    this.listCode = listCode;
  }
  public String getExpression() {
    return expression;
  }
  public void setExpression(String expression) {
    this.expression = expression;
  }
  public Integer getExpressionType() {
    return expressionType;
  }
  public void setExpressionType(Integer expressionType) {
    this.expressionType = expressionType;
  }

  public String getMarsAuthorityId() {
    return marsAuthorityId;
  }

  public void setMarsAuthorityId(String marsAuthorityId) {
    this.marsAuthorityId = marsAuthorityId;
  }
}
