/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthorityAstConverter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ChartArrayMarsAuthorityAstConverter
implements MarsAuthorityAstConverter {
    public static final String CONVERTER_KEY = "chartArrayMarsAuthorityAstConverter";

    @Override
    public String converterKey() {
        return CONVERTER_KEY;
    }

    @Override
    public boolean support(Class<?> sourceClass, boolean isArrayValue) {
        if (!isArrayValue) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(sourceClass);
    }

    @Override
    public Object converter(DatabaseType databaseType, Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
        String[] sourceValues = null;
        if (sourceValue instanceof JSONArray) {
            sourceValues = (String[])((JSONArray)sourceValue).toArray((Object[])new String[0]);
        } else {
            Object[] sourceValueObjects = (Object[])sourceValue;
            sourceValues = (String[])Arrays.stream(sourceValueObjects).map(Object::toString).toArray(String[]::new);
        }
        ArrayList sqlCharExprs = Lists.newArrayList();
        for (String sourceValueItem : sourceValues) {
            SQLCharExpr sqlCharExpr = new SQLCharExpr(sourceValueItem);
            sqlCharExprs.add(sqlCharExpr);
        }
        return sqlCharExprs;
    }

    @Override
    public SQLExpr op(String leftTableName, String leftAlias, String leftFieldName, Object right) {
        SQLPropertyExpr property = null;
        property = !StringUtils.isBlank((CharSequence)leftAlias) ? new SQLPropertyExpr(leftAlias, leftFieldName) : new SQLPropertyExpr(leftTableName, leftFieldName);
        SQLInListExpr op = new SQLInListExpr((SQLExpr)property);
        op.setTargetList((List)right);
        return op;
    }
}

