/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.sdk.converter;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthoritySqlConverter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMarsAuthoritySqlConverter
implements MarsAuthoritySqlConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMarsAuthoritySqlConverter.class);
    private static LoadingCache<String, Set<RepositoryTableNode>> appCodeTableNodes = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Set<RepositoryTableNode>>(){

        public Set<RepositoryTableNode> load(String key) throws Exception {
            return Sets.newConcurrentHashSet();
        }
    });

    @Override
    public Map<String, String> analysisTableFileds(Connection connection, String tableName, Map<String, Set<String>> requestMatchedFields) {
        String appCode = TenantUtils.getTenantCode();
        if (connection == null || StringUtils.isBlank((CharSequence)tableName) || CollectionUtils.isEmpty(requestMatchedFields)) {
            return null;
        }
        RepositoryTableNode tableNode = this.findCacheTableNode(appCode, tableName);
        if (tableNode == null) {
            tableNode = this.findRepositoryTableNode(connection, tableName);
            if (tableNode != null) {
                this.addCacheTableNode(appCode, tableNode);
            } else {
                return null;
            }
        }
        LinkedHashMap matchedDimensionMapping = Maps.newLinkedHashMap();
        Set<String> fieldNames = tableNode.getFields();
        block0: for (String filedName : fieldNames) {
            for (Map.Entry<String, Set<String>> requestMatchedFieldEntry : requestMatchedFields.entrySet()) {
                String dimensionKey = requestMatchedFieldEntry.getKey();
                Set<String> possibleFieldNames = requestMatchedFieldEntry.getValue();
                for (String possibleFieldName : possibleFieldNames) {
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)filedName, (CharSequence[])new CharSequence[]{possibleFieldName})) continue;
                    matchedDimensionMapping.put(dimensionKey, possibleFieldName);
                    continue block0;
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)matchedDimensionMapping)) {
            return null;
        }
        return matchedDimensionMapping;
    }

    private RepositoryTableNode findCacheTableNode(String appCode, String tableName) {
        Set repositoryTableNodes = null;
        try {
            repositoryTableNodes = (Set)appCodeTableNodes.get((Object)appCode);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        RepositoryTableNode currentTableNode = null;
        for (RepositoryTableNode repositoryTableNode : repositoryTableNodes) {
            if (!StringUtils.equals((CharSequence)repositoryTableNode.getTableName(), (CharSequence)tableName)) continue;
            currentTableNode = repositoryTableNode;
            break;
        }
        return currentTableNode;
    }

    private void addCacheTableNode(String appCode, RepositoryTableNode tableNode) {
        Set repositoryTableNodes = null;
        try {
            repositoryTableNodes = (Set)appCodeTableNodes.get((Object)appCode);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        repositoryTableNodes.add(tableNode);
    }

    protected abstract RepositoryTableNode findRepositoryTableNode(Connection var1, String var2);

    protected static class RepositoryTableNode {
        private String tableName;
        private Set<String> fields = Sets.newHashSet();

        public RepositoryTableNode(String tableName, Set<String> fields) {
            this.tableName = tableName;
            this.fields = fields;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Set<String> getFields() {
            return this.fields;
        }
    }
}

