package com.bizunited.nebula.mars.sdk.context;

/**
 * 数据权限上下文管理器
 * @author yinwenjie
 */
public class MarsAuthorityContextHolder {
  /**
   * 记录http request的head信息中，记录数据权限的head属性
   */
  public static final String FILTER_HEAD_KEY = "MARS_LIST_CODE"; 
  /**
   * 以线程为单位的上下文
   */
  private static final ThreadLocal<MarsAuthorityContext> CONTEXTHOLDER = new ThreadLocal<>();
  
  private MarsAuthorityContextHolder() {
    
  }
  
  public static void clearContext() {
    CONTEXTHOLDER.remove();
  }

  public static MarsAuthorityContext getContext() {
    MarsAuthorityContext ctx = CONTEXTHOLDER.get();
    if (ctx == null) {
      ctx = createEmptyContext();
      CONTEXTHOLDER.set(ctx);
    }
    return ctx;
  }

  private static MarsAuthorityContext createEmptyContext() {
    return new MarsAuthorityContextImpl();
  }
}
