package com.bizunited.nebula.mars.sdk.context;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;

/**
 * MarsAuthorityContext数据权限上下文的默认显示
 * @author yinwenjie
 */
@Component
class MarsAuthorityContextImpl implements MarsAuthorityContext {

  /**
   * 本次数据权限处理针对的列表Code
   */
  private String listCode;
  
  /**
   * 该属性描述了当前数据权限模块是否正在针对一条SQL构建数据权限信息
   */
  private Boolean building = false;
  /**
   * 本次SQL拦截执行，基于的已匹配的数据权限设定信息
   */
  private Set<String> matchedMarsAuthorityCodes;
  /**
   * 获取当前匹配的数据权限
   */
  private Set<MarsAuthority> matchedMarsAuthoritys;

  public String getListCode() {
    return listCode;
  }

  public void setListCode(String listCode) {
    this.listCode = listCode;
  }

  @Override
  public Boolean building() {
    return building;
  }

  @Override
  public void setBuilding(Boolean building) {
    this.building = building;
  }

  @Override
  public Set<String> getMatchedMarsAuthorityCodes() {
    return this.matchedMarsAuthorityCodes;
  }

  @Override
  public void setMatchedMarsAuthorityCodes(Set<String> marsAuthorityCodes) {
    this.matchedMarsAuthorityCodes = marsAuthorityCodes;
  }

  public Set<MarsAuthority> getMatchedMarsAuthoritys() {
    return matchedMarsAuthoritys;
  }

  public void setMatchedMarsAuthoritys(Set<MarsAuthority> matchedMarsAuthoritys) {
    this.matchedMarsAuthoritys = matchedMarsAuthoritys;
  }
}
