package com.bizunited.nebula.mars.sdk.converter;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;

import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthorityAstConverter;


/**
 * 该方法服务于最普遍使用的字符/字符串相等的判定条件构造，构造后的结构为：tt.a = 'xxxx'
 * @author yinwenjie
 */
@Component
public class ChartEqualMarsAuthorityAstConverter implements MarsAuthorityAstConverter {

  /**
   * 该转换器对应的转换器标识
   */
  public static final String CONVERTER_KEY = "chartEqualMarsAuthorityValueAstConverter";
  
  @Override
  public String converterKey() {
    return CONVERTER_KEY;
  }
  
  /**
   * 不支持数组，但只要是可串行化的字符类型都支持，例如String、Stringbuffer、StringBuild等等
   */
  @Override
  public boolean support(Class<?> sourceClass, boolean isArrayValue) {
    if(isArrayValue) {
      return false;
    }
    if(!CharSequence.class.isAssignableFrom(sourceClass)) {
      return false;
    }
    return true;
  }

  /**
   * 转换值的AST-Node的时候，将类型转换为SQLCharExpr
   */
  @Override
  public Object converter(DatabaseType databaseType, Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
    SQLCharExpr sqlCharExpr = new SQLCharExpr(sourceValue.toString());
    return sqlCharExpr;
  }

  @Override
  public SQLExpr op(String leftTableName , String leftAlias , String leftFieldName , Object right) {
    /*
     * 将数据表构造成SQLBinaryOpExpr节点的左儿子结构，使用SQLPropertyExpr类型进行表达；
     * 将值构造成SQLBinaryOpExpr节点的右儿子结构，使用原始的right进行表达；
     * 
     * 设置SQLBinaryOpExpr的操作符为“=”
     * */
    SQLPropertyExpr left = null;
    if(!StringUtils.isBlank(leftAlias)) {
      left = new SQLPropertyExpr(leftAlias, leftFieldName);
    } else {
      left = new SQLPropertyExpr(leftTableName, leftFieldName);
    }
    
    SQLBinaryOpExpr op = new SQLBinaryOpExpr(left, SQLBinaryOperator.Equality, (SQLExpr)right);
    return op;
  }
}
