package com.bizunited.nebula.mars.sdk.converter;

import org.springframework.stereotype.Component;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthorityAstConverter;

/**
 * 该方法服务于一个固定的TRUE条件转换器，即在SQL的WHERE部分加入一个固定的FALSE条件。</br>
 * 该转换器服务于默认的“不能查看任何数据”这个数据权限控制选项
 * @author yinwenjie
 */
@Component("fixFalseEqualMarsAuthorityAstConverter")
public class FixFalseEqualMarsAuthorityAstConverter implements MarsAuthorityAstConverter {

  /**
   * 该转换器对应的转换器标识
   */
  public static final String CONVERTER_KEY = "fixFalseEqualMarsAuthorityAstConverter";
  
  @Override
  public String converterKey() {
    return CONVERTER_KEY;
  }
  
  /**
   * 不支持数组，但只要是可串行化的字符类型都支持，例如String、Stringbuffer、StringBuild等等
   */
  @Override
  public boolean support(Class<?> sourceClass, boolean isArrayValue) {
    if(isArrayValue) {
      return false;
    }
    if(!CharSequence.class.isAssignableFrom(sourceClass)) {
      return false;
    }
    return true;
  }

  /**
   * 转换值的AST-Node的时候，将类型转换为SQLCharExpr
   */
  @Override
  public Object converter(DatabaseType databaseType, Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
    SQLCharExpr sqlCharExpr = new SQLCharExpr(sourceValue.toString());
    return sqlCharExpr;
  }

  @Override
  public SQLExpr op(String leftTableName , String leftAlias , String leftFieldName , Object right) {
    /*
     * 就设置一个FALSE操作符
     * */
    return SQLUtils.toSQLExpr("FALSE");
  }
}
