package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.bizunited.nebula.common.enums.DatabaseType;

/**
 * 非常重要的接口，负责完成特定数值类型向AST-Node的装换</p>
 * @author yinwenjie
 */
public interface MarsAuthorityAstConverter {
  /**
   * 转换器唯一的key值
   * @return
   */
  public String converterKey();
  /**
   * TODO 注释未写
   * @param sourceClass 
   * @param isArrayValue 
   * @param sourceValue 
   * @return 
   */
  public boolean support(Class<?> sourceClass , boolean isArrayValue);
  /**
   * 该方法可以将本转换接口所支持的值类型，转换成具体的AST-NODE表达式
   * @param databaseType 当前操作连接的数据库类型（这些数据库类型都是目前版本MARS所支持的数据库类型）
   * @param sourceClass 值的原始类型
   * @param isArrayValue 该值是否是一个数组（TODO 继续完善注释）
   * @param sourceValue 将要进行转换的原始值 
   * @return 注意，返回的节点类型可以是任意的druid解析后的AST-Node（或者AST-NODE的集合）。
   */
  public Object converter(DatabaseType databaseType , Class<?> sourceClass , boolean isArrayValue , Object sourceValue);
  
  /**
   * TODO 注释未写
   * @param leftTableName 左节点的表名信息（一定有）
   * @param leftAlias 左结点的别名信息（不一定有）
   * @param leftFieldName 左结点的字段名（一定有）
   * @param right 注意，该值对应converter方法的返回值（一定有值，否则不会执行）
   * @return
   */
  public SQLExpr op(String leftTableName , String leftAlias , String leftFieldName , Object right);
}
