package com.bizunited.nebula.mars.sdk.register;

import java.util.Set;

/**
 * 按照某个维度进行指定列表的数据权限设定时，这些维度都需要放置在某一个分组中，例如（按照客户维度授权），就是一个分组。</br>
 * 而这里的注册器，就是向数据全新中心，注册一个维度分组
 * @author yinwenjie
 */
public interface SelectAuthorityModeGroupRegister {
  /**
   * 数据权限选择方式分组编号（全系统唯一）
   * @return
   */
  public String groupCode();
  /**
   * 数据权限选择方式分组名称，以便在界面上进行显示
   * @return
   */
  public String groupName();
  /**
   * 怎么确定特定的列表，是否可以匹配某种维度分组来选择数据权限呢？</p>
   * 主要是看列表显示层，是否有某些特定的字段信息。</br>
   * 例如某个列表上，只要有字段A1或者A2，就可以通过本维度分组进行数据权限选择，那么这里就返回</p>
   * return 注意，区分大小写
   * @return
   */
  public Set<String> viewFieldNames();
  /**
   * 这里需要返回本数据权限维度分组感兴趣的数据库持久层的字段信息名
   * @return
   */
  public Set<String> repositoryFieldNames();
  /**
   * 这个具体的数据权限选择分组是否只能用于“默认”情况
   * @return
   */
  public default Boolean defaultGroup() {
    return false;
  }
}
