package com.bizunited.nebula.mars.sdk.register;

import com.bizunited.nebula.security.sdk.login.UserIdentity;

/**
 * 数据权限（mars）维度选择接口，既是数据维度设定时由客户在某个数据权限设定中选择的数据权限匹配维度</br>
 * 例如，按照角色确定数据权限的适用范围，或者按照组织来确定数据权限的适用范围。。。。。</p>
 * 
 * 每一种数据权限的适用范围都需要一个SelectScopeRegister
 * 
 * @author yinwenjie
 */
public interface SelectScopeRegister {
  /**
   * 数据权限适用范围在系统中唯一的编号信息
   */
  public String scopeKey();
  
  /**
   * 数据权限适用范围在系统中唯一的名字，以便显示在页面上
   */
  public String selectName();
  
  /**
   * 数据权限适用范围所使用的控件标识。例如组织机构树控件、职位树控件等等
   * @return 
   */
  public String controlKey();
  
  /**
   * 数据权限适用范围所使用的控件标识名称
   * @return
   */
  public String controlName();
  
  /**
   * 该方法标识当前的人员范围选择方式，是否是系统默认的人员范围选择方式。</br>
   * 这种默认的人员范围选择方式全系统只会有一个，且在特定的列表组件（mars_list_code），没有匹配当前操作者的情况下默认起作用
   * @return
   */
  public default Boolean defaultScope() {
    return false;
  }
  
  // ==============
  
  /**
   * 查询当前的范围注册器，在特定登录用户的条件是，是否匹配传入的scopeValues返回。</p>
   * @param loginDetails
   * @param scopeValues 当前选定的特定值（是一个数组）
   * @return
   */
  public boolean matched(UserIdentity loginDetails , String[] scopeValues);
}
