package com.bizunited.nebula.mars.sdk.service;

import java.util.Set;

import com.bizunited.nebula.mars.sdk.dto.MarsAuthorityDto;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;

/**
 * 该服务提供“mars数据权限”子系统基本的CRUD功能
 * @author yinwenjie
 */
public interface MarsAuthorityService {
  /**
   * 创建新的数据权限设定主数据
   * @return
   */
  public MarsAuthority create(MarsAuthorityDto marsAuthority);
  /**
   * 修改新的数据权限设定主数据，但请注意，修改数据时并不是所有数据都能修改。例如业务编码code就不能修改。
   * 数据权限设定信息的“启用”/“禁用”状态，也不能进行修改
   * @param marsAuthority 将要修改的数据权限信息
   * @return
   */
  public MarsAuthority update(MarsAuthorityDto marsAuthority);
  /**
   * 将一个数据权限设定为“有效”（只能是当前操作者所在租户）
   * @param code 数据权限业务编号
   */
  public void effective(String code);
  /**
   * 将一个数据权限设定为“无效”（只能是当前操作者所在租户）
   * @param code 数据权限业务编号
   * @param tenantCode
   */
  public void invalid(String code );
  /**
   * 按照业务编号进行数据权限设定的“删除”操作
   * @param code
   */
  public void deleteByCode(String code);
  /**
   * 按照数据权限设定的业务编号，进行某个具体数据权限设定信息的查询（不包括关联的信息）
   * @return
   */
  public MarsAuthority findByCode(String code);
  /**
   * 按照数据权限设定的业务编号，进行某个具体数据权限设定信息的查询（包括关联的信息）
   * @return
   */
  public MarsAuthority findDetailByCode(String code);
  /**
   * 按照listcode信息查询满足条件的数据权限设定信息（无论这些设定信息是否有效）
   * @param listCode 指定的listCode
   * @return
   */
  public Set<MarsAuthority> findByListCode(String listCode);
  
  /**
   * 按照指定的listCode列表编号，基于当前登录者和业务范围注册器，最终得到这个列表可正确匹配的数据权限信息
   * @param listCode 指定的listCode
   * @return
   */
  public Set<MarsAuthority> findByListCodeAndCurrentUser(String listCode);
}
