package com.bizunited.nebula.mars.sdk.service;

import java.util.List;

import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;

public interface SelectAuthorityModeGroupRegisterService {
  /**
   * 按照某个具体的数据选择分组维度code信息，进行查询
   * @param groupCode 分组维度的编号
   * @return
   */
  public SelectAuthorityModeGroupRegisterVo findByGroupCode(String groupCode);
  /**
   * 按照多个数据选择分组维度code信息，在去重后进行查询
   * @param groupCodes
   * @return
   */
  public List<SelectAuthorityModeGroupRegisterVo> findByGroupCodes(String[] groupCodes);
  /**
   * 给定一组显示字段信息，该服务方法会自动匹配和其相关的选择范围分组信息
   * @param viewFiledNames 一组字段信息
   * @param includeDefault 本次查询是否包括“默认”的数据权限分组（只有明确传入true，表达需要返回默认数据权限分组，才进行返回，否则都认为不需要返回）
   */
  public List<SelectAuthorityModeGroupRegisterVo> findByViewFieldNames(String[] viewFiledNames , Boolean includeDefault);
}
