package com.bizunited.nebula.mars.sdk.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;

public interface SelectAuthorityModeRegisterService {
  /**
   * 按照某个具体的选择维度分组的groupCode，查询属于这个维度分组下的所有可用维度选择项
   * @param groupCode 指定的分组业务编码（注意，返回的信息是排序的）
   */
  public List<SelectAuthorityModeRegisterVo> findByGroupCode(String groupCode);
  /**
   * 按照某个具体的选择维度key信息，进行查询
   * @param modeKey 选择方式在系统中唯一的key字符串信息
   * @return
   */
  public SelectAuthorityModeRegisterVo findByModeKey(String modeKey);
  /**
   * 根据一组数据权限设定信息，找到这组设定信息中，各个数据权限设定项的值</br>
   * 注意，该方法的返回信息包括了注册器的解析值
   * @param marsAuthorityCodes 可以是一个或者多个数据权限设定信息的业务编号
   * @return 注意返回信息：Key：数据权限设定项目信息的编号；</p>
   * Value：这是一个集合，即SelectAuthorityModeRegisterVo注册信息明细，以及注册器可能存储的固定值modeValue
   */
  public Map<String , Set<SelectAuthorityModeRegisterVo>> findByAuthorityCodes(Set<String> marsAuthorityCodes);
}
