/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.config;

import com.bizunited.nebula.monitor.rest.config.MonitorRestTemplate;
import com.bizunited.nebula.monitor.rest.utils.network.GzipInterceptor;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;

@Configuration
@EnableCaching
@ComponentScan(basePackages={"com.bizunited.nebula.monitor.rest"})
public class RestMonitorAutoConfiguration {
    @Bean
    public MonitorRestTemplate getMonitorRestTemplate() {
        OkHttpClient httpClient = this.getOkHttpClientBuilder().build();
        return new MonitorRestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(httpClient));
    }

    public static OkHttpClient.Builder getOkHttpClientBuilder() {
        int cacheSize = 0xA00000;
        Cache cache = null;
        try {
            File createTempFile = File.createTempFile("tutu_OkHttpCache_", ".tmp");
            cache = new Cache(createTempFile, (long)cacheSize);
            createTempFile.deleteOnExit();
        }
        catch (IOException createTempFile) {
            // empty catch block
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.cache(cache);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.addInterceptor((Interceptor)new GzipInterceptor());
        return builder;
    }
}

