/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.rest.service;

import com.bizunited.nebula.common.controller.model.ResponseCode;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.monitor.rest.config.MonitorRestTemplate;
import com.bizunited.nebula.monitor.rest.utils.MonitorCacheData;
import com.bizunited.nebula.monitor.sdk.bo.Cpu;
import com.bizunited.nebula.monitor.sdk.bo.Disk;
import com.bizunited.nebula.monitor.sdk.bo.Memory;
import com.bizunited.nebula.monitor.sdk.bo.MonitorAllBo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;

@Service
public class MonitorRestUtilService {
    private static final Logger log = LoggerFactory.getLogger(MonitorRestUtilService.class);
    @Autowired
    private MonitorRestTemplate restTemplate;
    private static final String URL_TEMP = "%s://%s:%d";
    private static final String URL_TEMP_CPU = "v1/monitor/cpu";
    private static final String URL_TEMP_MEMORY = "v1/monitor/memory";
    private static final String URL_TEMP_DISK = "v1/monitor/disk";
    private static final String URL_TEMP_ALL = "v1/monitor";
    private Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public Cpu getCpu(String scheme, String targetHost, int targetPort, String serviceId) {
        return this.getObject(scheme, targetHost, targetPort, serviceId, URL_TEMP_CPU, Cpu.class);
    }

    public Memory getMemory(String scheme, String targetHost, int targetPort, String serviceId) {
        return this.getObject(scheme, targetHost, targetPort, serviceId, URL_TEMP_MEMORY, Memory.class);
    }

    public Disk getDisk(String scheme, String targetHost, int targetPort, String serviceId) {
        return this.getObject(scheme, targetHost, targetPort, serviceId, URL_TEMP_DISK, Disk.class);
    }

    public MonitorAllBo getAll(String scheme, String targetHost, int targetPort, String serviceId) {
        return this.getObject(scheme, targetHost, targetPort, serviceId, URL_TEMP_ALL, MonitorAllBo.class);
    }

    private <T> T getObject(String scheme, String targetHost, int targetPort, String serviceId, String subUrlPath, Class<T> responseType) {
        MonitorCacheData cacheData;
        String url = this.getFormatUrl(scheme, targetHost, targetPort, serviceId, subUrlPath);
        if (this.cache.containsKey(url) && !(cacheData = (MonitorCacheData)this.cache.get(url)).isExpired()) {
            return cacheData.getData();
        }
        ResponseModel json = (ResponseModel)this.restTemplate.getForObject(url, ResponseModel.class, new Object[0]);
        Object data = null;
        if (json.getResponseCode() == ResponseCode.E0) {
            Map map = (Map)json.getData();
            try {
                data = responseType.newInstance();
                BeanMap.create(data).putAll(map);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            this.cache.put(url, new MonitorCacheData<Object>(data, System.currentTimeMillis() + 30000L));
        } else {
            log.error("\u8c03\u7528{}\u5f02\u5e38={}", (Object)url, (Object)json.getErrorMsg());
        }
        return data;
    }

    private String getFormatUrl(String scheme, String targetHost, int targetPort, String serviceId, String subUrlPath) {
        String urlStr = String.format(URL_TEMP, scheme, targetHost, targetPort);
        if (serviceId != null) {
            urlStr = urlStr + "/" + serviceId;
        }
        urlStr = urlStr + "/" + subUrlPath;
        return urlStr;
    }
}

