/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.sdk.bo;

import com.bizunited.nebula.monitor.sdk.serializer.SerializerDouble;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Memory {
    private long totalPhysicalMemory;
    private long freePhysicalMemory;
    private long usedPhysicalMemory;
    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    @JsonSerialize(using=SerializerDouble.class)
    private double physicalMemoryUsage;
    private long totalMemory;
    private long freeMemory;
    private long usedMemory;
    private long maxMemory;
    private long maxUseMemory;
    @JsonFormat(pattern="#.#########", shape=JsonFormat.Shape.NUMBER_FLOAT)
    @JsonSerialize(using=SerializerDouble.class)
    private double memoryUsage;

    public static MemoryBuilder builder() {
        return new MemoryBuilder();
    }

    public long getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public long getFreePhysicalMemory() {
        return this.freePhysicalMemory;
    }

    public long getUsedPhysicalMemory() {
        return this.usedPhysicalMemory;
    }

    public double getPhysicalMemoryUsage() {
        return this.physicalMemoryUsage;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxUseMemory() {
        return this.maxUseMemory;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setTotalPhysicalMemory(long totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
    }

    public void setFreePhysicalMemory(long freePhysicalMemory) {
        this.freePhysicalMemory = freePhysicalMemory;
    }

    public void setUsedPhysicalMemory(long usedPhysicalMemory) {
        this.usedPhysicalMemory = usedPhysicalMemory;
    }

    public void setPhysicalMemoryUsage(double physicalMemoryUsage) {
        this.physicalMemoryUsage = physicalMemoryUsage;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public void setUsedMemory(long usedMemory) {
        this.usedMemory = usedMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setMaxUseMemory(long maxUseMemory) {
        this.maxUseMemory = maxUseMemory;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Memory)) {
            return false;
        }
        Memory other = (Memory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalPhysicalMemory() != other.getTotalPhysicalMemory()) {
            return false;
        }
        if (this.getFreePhysicalMemory() != other.getFreePhysicalMemory()) {
            return false;
        }
        if (this.getUsedPhysicalMemory() != other.getUsedPhysicalMemory()) {
            return false;
        }
        if (Double.compare(this.getPhysicalMemoryUsage(), other.getPhysicalMemoryUsage()) != 0) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getUsedMemory() != other.getUsedMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        if (this.getMaxUseMemory() != other.getMaxUseMemory()) {
            return false;
        }
        return Double.compare(this.getMemoryUsage(), other.getMemoryUsage()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Memory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalPhysicalMemory = this.getTotalPhysicalMemory();
        result = result * 59 + (int)($totalPhysicalMemory >>> 32 ^ $totalPhysicalMemory);
        long $freePhysicalMemory = this.getFreePhysicalMemory();
        result = result * 59 + (int)($freePhysicalMemory >>> 32 ^ $freePhysicalMemory);
        long $usedPhysicalMemory = this.getUsedPhysicalMemory();
        result = result * 59 + (int)($usedPhysicalMemory >>> 32 ^ $usedPhysicalMemory);
        long $physicalMemoryUsage = Double.doubleToLongBits(this.getPhysicalMemoryUsage());
        result = result * 59 + (int)($physicalMemoryUsage >>> 32 ^ $physicalMemoryUsage);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $usedMemory = this.getUsedMemory();
        result = result * 59 + (int)($usedMemory >>> 32 ^ $usedMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        long $maxUseMemory = this.getMaxUseMemory();
        result = result * 59 + (int)($maxUseMemory >>> 32 ^ $maxUseMemory);
        long $memoryUsage = Double.doubleToLongBits(this.getMemoryUsage());
        result = result * 59 + (int)($memoryUsage >>> 32 ^ $memoryUsage);
        return result;
    }

    public String toString() {
        return "Memory(totalPhysicalMemory=" + this.getTotalPhysicalMemory() + ", freePhysicalMemory=" + this.getFreePhysicalMemory() + ", usedPhysicalMemory=" + this.getUsedPhysicalMemory() + ", physicalMemoryUsage=" + this.getPhysicalMemoryUsage() + ", totalMemory=" + this.getTotalMemory() + ", freeMemory=" + this.getFreeMemory() + ", usedMemory=" + this.getUsedMemory() + ", maxMemory=" + this.getMaxMemory() + ", maxUseMemory=" + this.getMaxUseMemory() + ", memoryUsage=" + this.getMemoryUsage() + ")";
    }

    public Memory() {
    }

    public Memory(long totalPhysicalMemory, long freePhysicalMemory, long usedPhysicalMemory, double physicalMemoryUsage, long totalMemory, long freeMemory, long usedMemory, long maxMemory, long maxUseMemory, double memoryUsage) {
        this.totalPhysicalMemory = totalPhysicalMemory;
        this.freePhysicalMemory = freePhysicalMemory;
        this.usedPhysicalMemory = usedPhysicalMemory;
        this.physicalMemoryUsage = physicalMemoryUsage;
        this.totalMemory = totalMemory;
        this.freeMemory = freeMemory;
        this.usedMemory = usedMemory;
        this.maxMemory = maxMemory;
        this.maxUseMemory = maxUseMemory;
        this.memoryUsage = memoryUsage;
    }

    public static class MemoryBuilder {
        private long totalPhysicalMemory;
        private long freePhysicalMemory;
        private long usedPhysicalMemory;
        private double physicalMemoryUsage;
        private long totalMemory;
        private long freeMemory;
        private long usedMemory;
        private long maxMemory;
        private long maxUseMemory;
        private double memoryUsage;

        MemoryBuilder() {
        }

        public MemoryBuilder totalPhysicalMemory(long totalPhysicalMemory) {
            this.totalPhysicalMemory = totalPhysicalMemory;
            return this;
        }

        public MemoryBuilder freePhysicalMemory(long freePhysicalMemory) {
            this.freePhysicalMemory = freePhysicalMemory;
            return this;
        }

        public MemoryBuilder usedPhysicalMemory(long usedPhysicalMemory) {
            this.usedPhysicalMemory = usedPhysicalMemory;
            return this;
        }

        public MemoryBuilder physicalMemoryUsage(double physicalMemoryUsage) {
            this.physicalMemoryUsage = physicalMemoryUsage;
            return this;
        }

        public MemoryBuilder totalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public MemoryBuilder freeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
            return this;
        }

        public MemoryBuilder usedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
            return this;
        }

        public MemoryBuilder maxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }

        public MemoryBuilder maxUseMemory(long maxUseMemory) {
            this.maxUseMemory = maxUseMemory;
            return this;
        }

        public MemoryBuilder memoryUsage(double memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        public Memory build() {
            return new Memory(this.totalPhysicalMemory, this.freePhysicalMemory, this.usedPhysicalMemory, this.physicalMemoryUsage, this.totalMemory, this.freeMemory, this.usedMemory, this.maxMemory, this.maxUseMemory, this.memoryUsage);
        }

        public String toString() {
            return "Memory.MemoryBuilder(totalPhysicalMemory=" + this.totalPhysicalMemory + ", freePhysicalMemory=" + this.freePhysicalMemory + ", usedPhysicalMemory=" + this.usedPhysicalMemory + ", physicalMemoryUsage=" + this.physicalMemoryUsage + ", totalMemory=" + this.totalMemory + ", freeMemory=" + this.freeMemory + ", usedMemory=" + this.usedMemory + ", maxMemory=" + this.maxMemory + ", maxUseMemory=" + this.maxUseMemory + ", memoryUsage=" + this.memoryUsage + ")";
        }
    }
}

