/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.monitor.sdk.serializer;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;

public class SerializerDouble
extends JsonSerializer<Double>
implements ContextualSerializer {
    protected DecimalFormat decimalFormat;

    public SerializerDouble() {
    }

    public SerializerDouble(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void serialize(Double value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.isNull(value)) {
            gen.writeNull();
        } else if (null != this.decimalFormat) {
            gen.writeNumber(this.decimalFormat.format(value));
        } else {
            gen.writeNumber(value.doubleValue());
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format == null) {
            return this;
        }
        if (format.hasPattern()) {
            DecimalFormat decimalFormat = new DecimalFormat(format.getPattern());
            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
            return new SerializerDouble(decimalFormat);
        }
        return this;
    }

    protected JsonFormat.Value findFormatOverrides(SerializerProvider provider, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat((MapperConfig)provider.getConfig(), typeForDefaults);
        }
        return provider.getDefaultPropertyFormat(typeForDefaults);
    }
}

