package com.bizunited.nebula.rbac.local.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import com.bizunited.nebula.rbac.local.service.internal.ButtonVoServiceImpl;
import com.bizunited.nebula.rbac.local.service.internal.CompetenceVoServiceImpl;
import com.bizunited.nebula.rbac.local.service.internal.RoleVoCacheServiceImpl;
import com.bizunited.nebula.rbac.local.service.internal.RoleVoServiceImpl;
import com.bizunited.nebula.rbac.local.service.notifier.AuthenticationRbacEventListenerImpl;
import com.bizunited.nebula.rbac.sdk.service.ButtonVoService;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;

/**
 * nebula 2.4+ 默认的用户模块实现，包括用户、组织机构、岗位和职级四个模块；</br>
 * 按照随后的架构梳理部署，这个模块还要进行拆分
 * @author yinwenjie
 */
@Configuration
@EntityScan(basePackages = "com.bizunited.nebula.rbac.local.entity")
@EnableJpaRepositories(basePackages = "com.bizunited.nebula.rbac.local.repository")
@ComponentScan(basePackages = "com.bizunited.nebula.rbac")
public class RbacServerStarterAutoConfiguration {
  @Bean
  @ConditionalOnMissingBean
  public ButtonVoService getButtonVoService() {
    return new ButtonVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public CompetenceVoService getCompetenceVoService() {
    return new CompetenceVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public RoleVoService getRoleVoService() {
    return new RoleVoServiceImpl();
  }
  
  @Bean
  @ConditionalOnMissingBean
  public RoleVoCacheService getRoleVoCacheService() {
    return new RoleVoCacheServiceImpl();
  }
  
  @Bean
  @Primary
  public AuthenticationRbacEventListener getAuthenticationRbacEventListener() {
    return new AuthenticationRbacEventListenerImpl();
  }
}
