package com.bizunited.nebula.rbac.local.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;

import javax.servlet.http.HttpServletRequest;
import java.util.Set;

/**
 * 功能服务相关接口.
 * @author yinwenjie
 * @version V1.0
 */
@RestController
@RequestMapping(value="/v1/rbac/competences")
public class CompetenceVoController extends BaseController {
  private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceVoController.class);
  @Autowired
  private CompetenceVoService competenceVoService;

  @ApiOperation(value = "该方法按照当前登录用户，查询给定的一组URL访问地址中，那些访问地址是可用的。")
  @RequestMapping(value = "/findByUrlResource", method = RequestMethod.GET)
  public ResponseModel findByUrlResource(@RequestParam(name="resources") @ApiParam(name = "resources", value = "") String[] resources ,
                                         HttpServletRequest request) {    
    try {
      Set<CompetenceVo> results = this.competenceVoService.findByResourcesAndCurrentAccount(resources);
      return this.buildHttpResult(results);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据显示和状态查询顶级的菜单详情信息，返回的数据包含按钮数据
   * @param viewItem
   * @param status
   * @return
   */
  @ApiOperation("根据显示和状态查询顶级的菜单详情信息，返回的数据包含按钮数据(从顶级菜单开始算起)")
  @GetMapping("/findByViewItemAndStatusAndParentNull")
  public ResponseModel findByViewItemAndStatusAndParentNull(@RequestParam(name = "viewItem") @ApiParam("是否是功能菜单上的功能栏目1：需要显示的；0：不需要显示的") Boolean viewItem,
                                                                   @RequestParam(name = "status" , required = false) @ApiParam("状态信息，1：正常；0：禁用") Integer status) {
    try {
      String tenantCode = TenantUtils.getTenantCode();
      Set<CompetenceVo> competenceVos = competenceVoService.findByViewItemAndStatusAndParentNull(viewItem, tenantCode, status);
      return this.buildHttpResult(competenceVos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = " 该方法按照当前操作者所拥有的一个或者多个角色信息的code信息，" +
          "1.对当前用户的角色名称与yml配置的管理员角色信息取交集，判定是否具有管理员角色,如果具有管理员权限，该接口直接返回约定的null" +
          "2.如果当前用户的角色没有包含管理员权限，那么就会查询当前用户所拥有的所有功能集" +
          "注：这里可能会存在当前用户还未分配功能权限的情况，如果在这里没有发现功能集competences有值，那么这里就会返回一个空的功能数组" +
          "3.查询指定父级功能下，能够被这些角色访问的viewItem为true的，处于正常状态的功能" +
          "注：此方法包含按钮的信息整合"
          , notes="如果没有传入parentId信息，则认为是针对根级功能做以上查询。并且只显示状态正确的那些功能")
  @RequestMapping(value = "/findByViewItemAndCurrentUser", method = RequestMethod.GET)
  public ResponseModel findByViewItemAndCurrentUser(@RequestParam(name="viewItem") @ApiParam(name = "viewItem", value = "是否是功能菜单上的功能栏目1：需要显示的；0：不需要显示的") Boolean viewItem) {
    try {
      Set<CompetenceVo> competenceVos = this.competenceVoService.findByViewItemAndCurrentAccount(viewItem);
      return this.buildHttpResult(competenceVos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "查询指定的角色roleCode查询已绑定的功能信息，且这些功能状态符合查询的要求，" +
      "注：1.该接口会对当前用户的角色名称与yml配置的管理员角色信息取交集，判定是否具有管理员角色,如果具有管理员权限，该接口直接返回约定的null" +
      "2.如果当前用户的角色没有包含管理员权限，那么就会查询当前用户所拥有的所有功能集" +
      "注：这里可能会存在当前用户还未分配功能权限的情况，如果在这里没有发现功能集competences有值，那么这里就会返回一个空的功能数组" +
      "3.查询指定父级功能下，能够被这些角色访问的viewItem为true的，处于正常状态的功能"
  )
  @RequestMapping(value = "/findByRoleCodesAndStatus", method = RequestMethod.GET)
  public ResponseModel findByRoleCodesAndStatus(@RequestParam(name="viewItem") @ApiParam(name = "viewItem", value = "是否是功能菜单上的功能栏目1：需要显示的；0：不需要显示的") Boolean viewItem ,
                                               @RequestParam(name="roleCodes") @ApiParam(name = "roleCodes", value = "指定的角色name（可以是多个），如是ADMIN、VISITOR") String[] roleCodes ,
                                               @RequestParam(name="status" , required=false) @ApiParam(name = "status", value = "状态（1正常/0禁用），这个状态信息不用必须，如果不传入则表示无论功能处于何种状态，都满足查询要求" , required=false) Integer status) {
    try {
      String tenantCode = TenantUtils.getTenantCode();
      Set<CompetenceVo> competenceVos = this.competenceVoService.findByViewItemAndRoleCodesAndStatus(viewItem , tenantCode, roleCodes, status);
      return this.buildHttpResult(competenceVos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据按钮Code查询绑定的接口信息
   * @return
   */
  @ApiOperation(value = "根据按钮Code查询绑定的接口信息")
  @GetMapping("/findByButtonCode")
  public ResponseModel findByButtonCode(@RequestParam(name = "buttonCode") @ApiParam(name = "buttonCode", value = "指定的按钮的业务编号信息") String buttonCode ){
    try {
      Set<CompetenceVo> competenceVos = this.competenceVoService.findByButtonCode(buttonCode);
      return this.buildHttpResult(competenceVos);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}