package com.bizunited.nebula.rbac.local.entity;

import com.bizunited.nebula.common.entity.TenantOpEntity;
import com.bizunited.nebula.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Set;

/**
 * 柯伊伯表单引擎用户角色信息
 * @author yinwenjie
 * @date 2021-05-21
 * @version V2.0
 */
@ApiModel(value = "RoleEntity" , description="柯伊伯表单引擎用户角色信息(带租户维度)")
@Entity
@Table(name = "engine_role",indexes = @Index(columnList = "role_code,tenant_code" , unique = true))
public class RoleEntity extends TenantOpEntity {
  
  private static final long serialVersionUID = -4750396018968101826L;
  
  /** 角色的业务编号. **/
  @Column(name = "role_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '角色的业务编号，租户中唯一存在'")
  @ApiModelProperty(name="roleCode" , value="角色的业务编号，租户中唯一存在" , required=true)
  @SaturnColumn(description="角色的业务编号")
  private String roleCode = "";
  
  /** 角色名称（中文说明） **/
  @ApiModelProperty(name="role_name" , value="角色名称（中文说明）" , required=true)
  @Column(name = "role_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '角色名称（中文说明）'")
  @SaturnColumn(description="角色名称（中文说明）")
  private String roleName = "";
  /** 
   * 角色类型编号 
   * T001：业务角色
   * T002：管理角色
   */
  @ApiModelProperty(name="roleType" , value="角色类型编号 T001：业务角色 T002：管理角色" , required=true)
  @Column(name = "role_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '角色类型编号  T001：业务角色  T002：管理角色'")
  @SaturnColumn(description="角色类型编号")
  private String roleType = "";
  
  /** 状态 1正常, 0禁用(枚举). **/
  @ApiModelProperty(name="tstatus" , value="状态 1正常, 0禁用." , required=true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '状态 1正常, 0禁用(枚举)'")
  @SaturnColumn(description="角色状态")
  private Integer tstatus = 1;
  /**
   * 是否系统角色，如果是系统角色就不允许操作者删除
   */
  @ApiModelProperty(name="isDeny" , value="是否系统角色，如果是系统角色就不允许操作者删除" , required=true)
  @Column(name = "is_deny", nullable = false, columnDefinition = "bit(1) COMMENT '是否系统角色，如果是系统角色就不允许操作者删除'")
  @SaturnColumn(description="是否系统角色")
  private Boolean isDeny = false;

  /** 角色后默认页面跳转路径 */
  @ApiModelProperty(name = "defaultUrl",value = "角色后默认页面跳转路径")
  @Column(name = "default_url",length = 512, columnDefinition = "varchar(512) COMMENT '角色后默认页面跳转路径'")
  @SaturnColumn(description = "角色默认页面跳转路径")
  private String defaultUrl;
  
  /** 备注.角色信息说明 **/
  @ApiModelProperty(name="comment" , value="备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串" , required=false)
  @Column(name = "comment", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '备注.角色信息说明，备注信息不用填写，但是至少需要在写操作时传入空字符串'")
  @SaturnColumn(description="角色备注")
  private String comment = "";
  /**
   * 角色的父级
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "parent_id", columnDefinition = "varchar(255) COMMENT '角色的父级ID'")
  @ApiModelProperty(name="parent" , value="角色的父级")
  @SaturnColumn(description="角色的父级")
  private RoleEntity parent;
  /**
   * 角色下级
   */
  @OrderBy("createTime desc")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  @ApiModelProperty("角色下级")
  @SaturnColumn(description = "角色下级")
  private Set<RoleEntity> children;
  /**
   * 角色和按钮的对应关系
   */
  @ApiModelProperty("角色和按钮的对应关系")
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_role_button_mapping", joinColumns = {@JoinColumn(name = "role_id")}, inverseJoinColumns = {@JoinColumn(name = "button_id")})
  @SaturnColumn(description = "角色和按钮的对应关系")
  private Set<ButtonEntity> buttons;

  /** 角色和功能菜单的对应关系. **/
  @ApiModelProperty(name="competences" , value="角色和功能菜单的对应关系" , hidden = true , required=true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_role_competence_mapping", joinColumns = {@JoinColumn(name = "role_id")}, inverseJoinColumns = {@JoinColumn(name = "competence_id")})
  @SaturnColumn(description="角色和功能菜单的对应关系")
  private Set<CompetenceEntity> competences;
  
  public RoleEntity getParent() {
    return parent;
  }
  public void setParent(RoleEntity parent) {
    this.parent = parent;
  }
  public String getRoleCode() {
    return roleCode;
  }
  public void setRoleCode(String roleCode) {
    this.roleCode = roleCode;
  }
  public String getRoleName() {
    return roleName;
  }
  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }
  public String getRoleType() {
    return roleType;
  }
  public void setRoleType(String roleType) {
    this.roleType = roleType;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Boolean getIsDeny() {
    return isDeny;
  }
  public void setIsDeny(Boolean isDeny) {
    this.isDeny = isDeny;
  }
  public String getDefaultUrl() {
    return defaultUrl;
  }
  public void setDefaultUrl(String defaultUrl) {
    this.defaultUrl = defaultUrl;
  }
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }
  public Set<ButtonEntity> getButtons() {
    return buttons;
  }
  public void setButtons(Set<ButtonEntity> buttons) {
    this.buttons = buttons;
  }
  public Set<CompetenceEntity> getCompetences() {
    return competences;
  }
  public void setCompetences(Set<CompetenceEntity> competences) {
    this.competences = competences;
  }
  public Set<RoleEntity> getChildren() {
    return children;
  }
  public void setChildren(Set<RoleEntity> children) {
    this.children = children;
  }
}