package com.bizunited.nebula.rbac.local.service;

import java.util.Set;

import com.bizunited.nebula.rbac.local.entity.ButtonEntity;

/**
 * 按钮的相关接口
 * @author: zengxingwang
 * @date: 2020/1/13 14:43
 */
public interface ButtonService {
  /**
   * 创建按钮
   * @param button
   * @return
   */
  ButtonEntity create(ButtonEntity button);
  /**
   * 批量创建按钮
   * @param buttons
   * @return
   */
  void batchCreate(Set<ButtonEntity> buttons);
  /**
   * 修改按钮信息
   * @param button
   * @return
   */
  ButtonEntity update(ButtonEntity button);
  /**
   * 建立指定角色和指定按钮的绑定关系
   * @param roleId
   * @param buttonIds
   */
  void bindRole(String roleId, String[] buttonIds);
  /**
   * 重新进行按钮-角色的绑定
   * @param roleId
   * @param buttonIds
   */
  void rebindRole(String roleId, String[] buttonIds);
  /**
   * 取消指定角色和指定按钮的绑定关系
   * @param roleId
   * @param buttonIds
   */
  void unbindRole(String roleId, String[] buttonIds);
  /**
   * 取消指定角色的和已绑定按钮的绑定关系
   * @param roleId
   */
  void unbindAllRoles(String roleId);
  /**
   * 根据id批量删除按钮
   * @param ids
   */
  void batchDelete(String[] ids);
  /**
   * 根据id删除按钮
   * @param id
   */
  void deleteById(String id);
}
