package com.bizunited.nebula.rbac.local.service.notifier;

import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;

/**
 * 当功能模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了角色信息的变化。
 * @author yinwenjie
 */
@Component("CacheRedisMessageForCompetenceListenerImpl")
public class CacheRedisMessageForCompetenceListenerImpl implements MessageListener<String> {

  @Autowired
  private CompetenceVoService competenceVoService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForCompetenceListenerImpl.class);
  
  // 注意，这里是appCode
  @Override
  public void onMessage(CharSequence channel, String appCode) {
    LOGGER.info("all competence notifing ......");
    this.competenceVoService.clearCache(appCode);
  }
}
