package com.bizunited.nebula.rbac.local.service.notifier;

import org.apache.commons.lang3.StringUtils;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;

/**
 * 当角色模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了角色信息的变化
 * 这时需要接受redis的监听消息，以便进行缓存刷新——按照指定tenantcode下的指定roleCode进行缓存清理
 * @author yinwenjie
 */
@Component("CacheRedisMessageForRoleIdentityListenerImpl")
public class CacheRedisMessageForRoleIdentityListenerImpl implements MessageListener<String> {

  @Autowired
  private RoleVoCacheService roleVoService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForRoleIdentityListenerImpl.class);
  
  @Override
  public void onMessage(CharSequence channel, String tenantCodeAndRoleCode) {
    LOGGER.info("tenant role identity notifing ......");
    // tenant code和role code采用“|”进行分割，之所以不使用“_”，是因为RoleCode可能使用“_”
    String[] tenantCodeAndRoleCodeArray = StringUtils.split(tenantCodeAndRoleCode , "|");
    if(tenantCodeAndRoleCodeArray == null || tenantCodeAndRoleCodeArray.length != 2) {
      LOGGER.warn("tenant role identity string format error ......");
      return;
    }
    
    String tenantCode = tenantCodeAndRoleCodeArray[0];
    String roleCode = tenantCodeAndRoleCodeArray[1];
    if(!StringUtils.isBlank(tenantCode)) {
      this.roleVoService.clearCache(tenantCode, roleCode);
    }
  }
}
