package com.bizunited.nebula.rbac.local.service.strategy;

import java.util.ArrayList;
import java.util.LinkedHashSet;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;

/**
 * 该抽象类用于检查各查询策略器的实现难度，规范返回数据的格式
 * @author yinwenjie
 */
public abstract class AbstractCompetenceQueryStrategy {
  
  protected NebulaToolkitService nebulaToolkitService = new NebulaToolkitService();
  
  /**
   * 该私有方法，用于进行CompetenceVo副本的拷贝，特别注意父级CompetenceVo的副本拷贝。而关联的按钮和下级菜单/功能不在这里进行副本拷贝
   * @param cacheResults
   * @return
   */
  protected CompetenceVo copyCompetence(CompetenceVo sourceCompetence) {
    // 只做自身的copy，不做任何关联信息（下级菜单/功能、关联按钮）的copy
    CompetenceVo copy = this.nebulaToolkitService.copyObjectByWhiteList(sourceCompetence, CompetenceVo.class, LinkedHashSet.class, ArrayList.class,"buttons");
    CompetenceVo parent = sourceCompetence.getParent();
    if(parent != null) {
      CompetenceVo parentCopy = new CompetenceVo();
      parentCopy.setId(parent.getId());
      parentCopy.setCode(parent.getCode());
      parentCopy.setComment(parent.getComment());
      parentCopy.setDescription(parent.getDescription());
      parentCopy.setIcon(parent.getIcon());
      parentCopy.setMethods(parent.getMethods());
      parentCopy.setResource(parent.getResource());
      parentCopy.setTag(parent.getTag());
      parentCopy.setTstatus(parent.getTstatus());
      parentCopy.setType(parent.getType());
      parentCopy.setViewItem(parent.getViewItem());
      copy.setParent(parentCopy);
    }
    return copy;
  }
}
