package com.bizunited.nebula.rbac.local.service.strategy;

import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;

/**
 * 菜单/功能-按钮 树结构的查询策略接口，该接口的实现将配合CompetenceVoServiceImpl中的各种查询要求进行工作
 * @author yinwenjie
 */
public interface CompetenceQueryStrategy {
  /**
   * 在进行全功能树查询时，指定的功能节点是否允许作为查询结果，作为树上的一个节点返回给查询者
   * @param competence 指定的菜单/功能信息
   * @return 注意，如果允许作为查询结果进行返回，则返回一个经过中度拷贝的新的CompetenceVo对象副本；如果不允许作为查询结果进行返回，则返回null</p>
   * 另外需要注意的是，必须是一个新的副本对象，如果返回的对象与competence对象相等，则会排除异常
   * 要进行competence对象的中度拷贝，可以直接使用AbstractCompetenceQueryStrategy中提供的公共方法
   */
  public CompetenceVo filterCompetence(CompetenceVo competence);
  
  /**
   * 在进行全功能树查询时，指定的按钮节点，是否允许作为查询结果，作为树上的一个节点返回给查询者
   * @param button 指定的按钮信息
   * @return 参见filterCompetence的返回特点
   */
  public ButtonVo filterButton(ButtonVo button);
}
