package com.bizunited.nebula.rbac.local.service.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

/**
 * 可以指定按钮编号、角色编号，进行菜单/功能查询；还能指定是否只查询顶级菜单
 * @author yinwenjie
 */
public class QueryByButtonCodeAndRoleCodes extends AbstractCompetenceQueryStrategy implements CompetenceQueryStrategy {
  /**
   * 可能作为查询条件的租户和角色编号组
   */
  private String tenantCode;
  /**
   * 可能作为查询条件的
   */
  private String[] roleCodes;
  /**
   * 可能作为查询条件的菜单/功能节点性质
   */
  private Boolean viewItem;
  /**
   * 按钮编号
   */
  private String buttonCode;
  /**
   * 指定的是否作为管理员角色进行过滤判定
   */
  private boolean isAdmin;
  /**
   * 可忽略方法级判定的角色名
   */
  private String[] ignoreMethodCheckRoles;
  public QueryByButtonCodeAndRoleCodes(String tenantCode, String[] roleCodes, Boolean viewItem , String buttonCode , boolean isAdmin, String[] ignoreMethodCheckRoles) {
    super();
    this.tenantCode = tenantCode;
    this.roleCodes = roleCodes;
    this.viewItem = viewItem;
    this.buttonCode = buttonCode;
    this.isAdmin = isAdmin;
    this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
  }
  
  @Override
  public CompetenceVo filterCompetence(CompetenceVo competence) {
    Integer targetViewItem = competence.getViewItem();
    // 注意缓存中roles的格式 tenantcode_roleCode，并以","分割
    String targetRoles = competence.getRoles();
    
    /*
     * 1、首先进行节点自身可用性、性质的过滤，如果不满足，则不返回
     * 2、然后按照可能的按钮编号进行过滤
     * 3、最后再进行节点所属角色的过滤，如果角色过滤不满足，则不返回
     * */
    
    // 1、=======
    if(this.viewItem != null && this.viewItem != (targetViewItem == 1?true:false)) {
      return null;
    }
    
    // 2、=======
    Set<ButtonVo> buttons = competence.getButtons();
    if(!StringUtils.isBlank(this.buttonCode)) {
      if(!CollectionUtils.isEmpty(buttons)
          && buttons.stream().filter(item -> StringUtils.equals(item.getCode() , this.buttonCode)).count() == 0l) {
        return null;
      } 
    }
    
    // 3、======
    CompetenceVo copyCompetence = this.copyCompetence(competence);
    String[] matchedRolesReuslt = new String[] {};
    if(!this.isAdmin && StringUtils.isNotBlank(tenantCode) && roleCodes != null && roleCodes.length > 0) {
      if(!StringUtils.isEmpty(targetRoles)) {
        List<String> matchTargetRoles = Lists.newArrayList();
        for (String roleCode : roleCodes) {
          matchTargetRoles.add(StringUtils.join(tenantCode , "|" , roleCode));
        }
        String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[] {});
        String[] matchedRoles = Arrays.stream(StringUtils.split(targetRoles, ",")).filter(item -> StringUtils.equalsAny(item, matchTargetRoleArray)).toArray(String[]::new);
        // 如果条件成立，说明并没有匹配到任何角色,则不进行返回
        if(matchedRoles == null || matchedRoles.length == 0) {
          return null;
        } else {
          matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split(item , "|")[1]).toArray(String[]::new);
        }
      } else {
        return null;
      }
    } 
    // 如果认定是通过管理员权限进行的过滤，则返回的CompetenceVo绑定ignoreMethodCheckRoles
    else if(this.isAdmin) {
      matchedRolesReuslt = this.ignoreMethodCheckRoles;
    }
    copyCompetence.setRoles(StringUtils.join(matchedRolesReuslt , ","));
    return copyCompetence;
  }
  
  @Override
  public ButtonVo filterButton(ButtonVo button) {
    // 注意缓存中roles的格式 tenantcode_roleCode，并以","分割
    Set<String> targetRoles = button.getRoles();
    ButtonVo copyButton = this.nebulaToolkitService.copyObjectByWhiteList(button, ButtonVo.class, LinkedHashSet.class, ArrayList.class);
    
    // 以下是匹配可能额角色信息
    Set<String> matchedRolesReuslt = Sets.newLinkedHashSet();
    if(!this.isAdmin && StringUtils.isNotBlank(tenantCode) && roleCodes != null && roleCodes.length > 0) {
      if(!CollectionUtils.isEmpty(targetRoles)) {
        List<String> matchTargetRoles = Lists.newArrayList();
        for (String roleCode : roleCodes) {
          matchTargetRoles.add(StringUtils.join(tenantCode , "|" , roleCode));
        }
        String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[] {});
        String[] matchedRoles = targetRoles.stream().filter(item -> StringUtils.equalsAny(item, matchTargetRoleArray)).toArray(String[]::new);
        // 如果条件成立，说明并没有匹配到任何角色,则不进行返回
        if(matchedRoles == null || matchedRoles.length == 0) {
          return null;
        } else {
          matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split(item , "|")[1]).collect(Collectors.toSet());
        }
      } else {
        return null;
      }
    } // 如果认定是通过管理员权限进行的过滤，则返回的ButtonVo绑定ignoreMethodCheckRoles
    else if(this.isAdmin) {
      matchedRolesReuslt = Sets.newHashSet(this.ignoreMethodCheckRoles);
    } 
    // 其它情况，说明没有使用角色进行过滤（或者角色过滤条件不起作用）
    else {
      matchedRolesReuslt = targetRoles;
    }
    copyButton.setRoles(matchedRolesReuslt);
    return copyButton;
  }
}
