/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.rbac.sdk.service.ButtonVoService;
import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/buttons"})
public class ButtonVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonVoController.class);
    @Autowired
    private ButtonVoService buttonService;

    @ApiOperation(value="\u6839\u636e\u6309\u94aeid\u67e5\u8be2\u6309\u94ae\u4fe1\u606f(\u5305\u62ec\u5173\u8054\u4fe1\u606f)")
    @GetMapping(value={"findById"})
    public ResponseModel findById(@RequestParam(name="buttonId") @ApiParam(name="buttonId", value="\u6307\u5b9a\u7684\u6309\u94ae\u7684\u7f16\u53f7\u4fe1\u606f") String buttonId) {
        try {
            ButtonVo buttonVo = this.buttonService.findById(buttonId);
            return this.buildHttpResult(buttonVo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6309\u94ae\u7684\u4e1a\u52a1\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2")
    @GetMapping(value={"findByCode"})
    public ResponseModel findByCode(@RequestParam(name="code") @ApiParam(name="code", value="\u6307\u5b9a\u7684\u6309\u94ae\u7684\u4e1a\u52a1\u7f16\u53f7") String code) {
        try {
            ButtonVo buttonVo = this.buttonService.findByCode(code);
            return this.buildHttpResult(buttonVo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCurrentUser"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u6309\u94ae\u6743\u9650", notes="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u6309\u94ae\u6743\u9650,\u5982\u679c\u5f53\u524d\u767b\u5f55\u7528\u6237\u6709\u5ffd\u7565\u6743\u9650\u7684\u6309\u94ae\uff0c\u90a3\u5c31\u8fd4\u56de\u6240\u6709\u7684\u6743\u9650\u6309\u94ae")
    public ResponseModel findByCurrentUser() {
        try {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            String account = null;
            if (securityContext != null && securityContext.getAuthentication() != null && StringUtils.isNotBlank((CharSequence)(account = securityContext.getAuthentication().getName()))) {
                Set buttonVos = this.buttonService.findByAcconut(account);
                return this.buildHttpResult(buttonVos);
            }
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByTopCompetenceId"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355ID\u67e5\u8be2\u6309\u94ae", notes="\u6839\u636e\u83dc\u5355ID\u67e5\u8be2\u6309\u94ae")
    public ResponseModel findByTopCompetenceId(@ApiParam(name="competenceId", value="\u6309\u94aeID", required=true) @RequestParam(value="topCompetenceId") String topCompetenceId) {
        try {
            Set result = this.buttonService.findByTopCompetenceId(topCompetenceId);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByRoleCodeAndCompetenceId"})
    @ApiOperation(value="\u6309\u7167\u6309\u94ae\u4ece\u5c5e\u7684\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7\u548c\u529f\u80fd\u6280\u672f\u7f16\u53f7\uff0c\u67e5\u8be2\u6309\u94ae\u4fe1\u606f")
    public ResponseModel findByRoleCodeAndCompetenceId(@ApiParam(name="roleCode", value="\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7") @RequestParam(value="roleCode") String roleCode, @ApiParam(name="topCompetenceId", value="\u83dc\u5355\u7684\u4e1a\u52a1\u7f16\u53f7") @RequestParam(value="topCompetenceId") String topCompetenceId) {
        try {
            Set result = this.buttonService.findByRoleCodesAndTopCompetenceId((List)Lists.newArrayList((Object[])new String[]{roleCode}), topCompetenceId);
            return this.buildHttpResult(result);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

