/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/competences"})
public class CompetenceVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceVoController.class);
    @Autowired
    private CompetenceVoService competenceVoService;

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u6309\u7167\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u67e5\u8be2\u7ed9\u5b9a\u7684\u4e00\u7ec4URL\u8bbf\u95ee\u5730\u5740\u4e2d\uff0c\u90a3\u4e9b\u8bbf\u95ee\u5730\u5740\u662f\u53ef\u7528\u7684\u3002")
    @RequestMapping(value={"/findByUrlResource"}, method={RequestMethod.GET})
    public ResponseModel findByUrlResource(@RequestParam(name="resources") @ApiParam(name="resources", value="") String[] resources, HttpServletRequest request) {
        try {
            Set results = this.competenceVoService.findByResourcesAndCurrentAccount(resources);
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u663e\u793a\u548c\u72b6\u6001\u67e5\u8be2\u9876\u7ea7\u7684\u83dc\u5355\u8be6\u60c5\u4fe1\u606f\uff0c\u8fd4\u56de\u7684\u6570\u636e\u5305\u542b\u6309\u94ae\u6570\u636e(\u4ece\u9876\u7ea7\u83dc\u5355\u5f00\u59cb\u7b97\u8d77)")
    @GetMapping(value={"/findByViewItemAndStatusAndParentNull"})
    public ResponseModel findByViewItemAndStatusAndParentNull(@RequestParam(name="viewItem") @ApiParam(value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem, @RequestParam(name="status", required=false) @ApiParam(value="\u72b6\u6001\u4fe1\u606f\uff0c1\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528") Integer status) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set competenceVos = this.competenceVoService.findByViewItemAndStatusAndParentNull(viewItem, tenantCode, status);
            return this.buildHttpResult(competenceVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value=" \u8be5\u65b9\u6cd5\u6309\u7167\u5f53\u524d\u64cd\u4f5c\u8005\u6240\u62e5\u6709\u7684\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u89d2\u8272\u4fe1\u606f\u7684code\u4fe1\u606f\uff0c1.\u5bf9\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u540d\u79f0\u4e0eyml\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u89d2\u8272\u4fe1\u606f\u53d6\u4ea4\u96c6\uff0c\u5224\u5b9a\u662f\u5426\u5177\u6709\u7ba1\u7406\u5458\u89d2\u8272,\u5982\u679c\u5177\u6709\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8be5\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u7ea6\u5b9a\u7684null2.\u5982\u679c\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6ca1\u6709\u5305\u542b\u7ba1\u7406\u5458\u6743\u9650\uff0c\u90a3\u4e48\u5c31\u4f1a\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u7684\u6240\u6709\u529f\u80fd\u96c6\u6ce8\uff1a\u8fd9\u91cc\u53ef\u80fd\u4f1a\u5b58\u5728\u5f53\u524d\u7528\u6237\u8fd8\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u7684\u60c5\u51b5\uff0c\u5982\u679c\u5728\u8fd9\u91cc\u6ca1\u6709\u53d1\u73b0\u529f\u80fd\u96c6competences\u6709\u503c\uff0c\u90a3\u4e48\u8fd9\u91cc\u5c31\u4f1a\u8fd4\u56de\u4e00\u4e2a\u7a7a\u7684\u529f\u80fd\u6570\u7ec43.\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u529f\u80fd\u4e0b\uff0c\u80fd\u591f\u88ab\u8fd9\u4e9b\u89d2\u8272\u8bbf\u95ee\u7684viewItem\u4e3atrue\u7684\uff0c\u5904\u4e8e\u6b63\u5e38\u72b6\u6001\u7684\u529f\u80fd\u6ce8\uff1a\u6b64\u65b9\u6cd5\u5305\u542b\u6309\u94ae\u7684\u4fe1\u606f\u6574\u5408", notes="\u5982\u679c\u6ca1\u6709\u4f20\u5165parentId\u4fe1\u606f\uff0c\u5219\u8ba4\u4e3a\u662f\u9488\u5bf9\u6839\u7ea7\u529f\u80fd\u505a\u4ee5\u4e0a\u67e5\u8be2\u3002\u5e76\u4e14\u53ea\u663e\u793a\u72b6\u6001\u6b63\u786e\u7684\u90a3\u4e9b\u529f\u80fd")
    @RequestMapping(value={"/findByViewItemAndCurrentUser"}, method={RequestMethod.GET})
    public ResponseModel findByViewItemAndCurrentUser(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem) {
        try {
            Set competenceVos = this.competenceVoService.findByViewItemAndCurrentAccount(viewItem);
            return this.buildHttpResult(competenceVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7684\u89d2\u8272roleCode\u67e5\u8be2\u5df2\u7ed1\u5b9a\u7684\u529f\u80fd\u4fe1\u606f\uff0c\u4e14\u8fd9\u4e9b\u529f\u80fd\u72b6\u6001\u7b26\u5408\u67e5\u8be2\u7684\u8981\u6c42\uff0c\u6ce8\uff1a1.\u8be5\u63a5\u53e3\u4f1a\u5bf9\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u540d\u79f0\u4e0eyml\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u89d2\u8272\u4fe1\u606f\u53d6\u4ea4\u96c6\uff0c\u5224\u5b9a\u662f\u5426\u5177\u6709\u7ba1\u7406\u5458\u89d2\u8272,\u5982\u679c\u5177\u6709\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8be5\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u7ea6\u5b9a\u7684null2.\u5982\u679c\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6ca1\u6709\u5305\u542b\u7ba1\u7406\u5458\u6743\u9650\uff0c\u90a3\u4e48\u5c31\u4f1a\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u7684\u6240\u6709\u529f\u80fd\u96c6\u6ce8\uff1a\u8fd9\u91cc\u53ef\u80fd\u4f1a\u5b58\u5728\u5f53\u524d\u7528\u6237\u8fd8\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u7684\u60c5\u51b5\uff0c\u5982\u679c\u5728\u8fd9\u91cc\u6ca1\u6709\u53d1\u73b0\u529f\u80fd\u96c6competences\u6709\u503c\uff0c\u90a3\u4e48\u8fd9\u91cc\u5c31\u4f1a\u8fd4\u56de\u4e00\u4e2a\u7a7a\u7684\u529f\u80fd\u6570\u7ec43.\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u529f\u80fd\u4e0b\uff0c\u80fd\u591f\u88ab\u8fd9\u4e9b\u89d2\u8272\u8bbf\u95ee\u7684viewItem\u4e3atrue\u7684\uff0c\u5904\u4e8e\u6b63\u5e38\u72b6\u6001\u7684\u529f\u80fd")
    @RequestMapping(value={"/findByRoleCodesAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByRoleCodesAndStatus(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem, @RequestParam(name="roleCodes") @ApiParam(name="roleCodes", value="\u6307\u5b9a\u7684\u89d2\u8272name\uff08\u53ef\u4ee5\u662f\u591a\u4e2a\uff09\uff0c\u5982\u662fADMIN\u3001VISITOR") String[] roleCodes, @RequestParam(name="status", required=false) @ApiParam(name="status", value="\u72b6\u6001\uff081\u6b63\u5e38/0\u7981\u7528\uff09\uff0c\u8fd9\u4e2a\u72b6\u6001\u4fe1\u606f\u4e0d\u7528\u5fc5\u987b\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u5219\u8868\u793a\u65e0\u8bba\u529f\u80fd\u5904\u4e8e\u4f55\u79cd\u72b6\u6001\uff0c\u90fd\u6ee1\u8db3\u67e5\u8be2\u8981\u6c42", required=false) Integer status) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set competenceVos = this.competenceVoService.findByViewItemAndRoleCodesAndStatus(viewItem, tenantCode, roleCodes, status);
            return this.buildHttpResult(competenceVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6309\u94aeCode\u67e5\u8be2\u7ed1\u5b9a\u7684\u63a5\u53e3\u4fe1\u606f")
    @GetMapping(value={"/findByButtonCode"})
    public ResponseModel findByButtonCode(@RequestParam(name="buttonCode") @ApiParam(name="buttonCode", value="\u6307\u5b9a\u7684\u6309\u94ae\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") String buttonCode) {
        try {
            Set competenceVos = this.competenceVoService.findByButtonCode(buttonCode);
            return this.buildHttpResult(competenceVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

