/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.repository;

import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.internal.RoleRepositoryCustom;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface RoleRepository
extends RoleRepositoryCustom,
JpaRepository<RoleEntity, String>,
JpaSpecificationExecutor<RoleEntity> {
    @Modifying
    @Query(value="delete from engine_role where tenant_code = :tenantCode and role_code = :roleCode", nativeQuery=true)
    public void deleteByTenantCodeAndRoleCode(@Param(value="tenantCode") String var1, @Param(value="roleCode") String var2);

    public List<RoleEntity> findByTenantCodeAndTstatus(@Param(value="tenantCode") String var1, @Param(value="useStatus") Integer var2);

    public RoleEntity findByTenantCodeAndRoleCode(String var1, String var2);

    public RoleEntity findByTenantCodeAndRoleName(@Param(value="tenantCode") String var1, @Param(value="roleName") String var2);

    @Query(value="select distinct r from RoleEntity r  left join fetch r.buttons b  left join fetch r.competences c  where c.id = :competenceId ")
    public List<RoleEntity> findByCompetenceId(@Param(value="competenceId") String var1);

    @Query(value="select distinct r from RoleEntity r  left join fetch r.buttons b  left join fetch r.competences c  where b.id = :buttonId ")
    public List<RoleEntity> findByButtonId(@Param(value="buttonId") String var1);

    @Query(value="from RoleEntity m where m.id in :ids")
    public Set<RoleEntity> findByIds(@Param(value="ids") List<String> var1);

    public Set<RoleEntity> findByTenantCodeAndParentIsNull(@Param(value="tenantCode") String var1);

    @Query(value="from RoleEntity r where r.tenantCode = :tenantCode and r.parent.id = :parentId ")
    public Set<RoleEntity> findByTenantCodeAndParent(@Param(value="tenantCode") String var1, @Param(value="parentId") String var2);

    @Query(value="from RoleEntity r where r.tenantCode = :tenantCode and r.roleName in :roleNames ")
    public Set<RoleEntity> findByTenantCodeAndRoleNames(@Param(value="tenantCode") String var1, @Param(value="roleNames") Set<String> var2);

    @Query(value="from RoleEntity r where r.tenantCode = :tenantCode and r.roleCode in :roleCodes ")
    public Set<RoleEntity> findByTenantCodeAndRoleCodes(@Param(value="tenantCode") String var1, @Param(value="roleCodes") Set<String> var2);

    @Query(value="select distinct r from RoleEntity r  left join fetch r.competences c  left join fetch r.buttons b  where r.id = :id ")
    public RoleEntity findDetailsById(@Param(value="id") String var1);
}

