/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.internal;

import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.entity.ButtonEntity;
import com.bizunited.nebula.rbac.local.entity.CompetenceEntity;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.ButtonRepository;
import com.bizunited.nebula.rbac.local.repository.CompetenceRepository;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.local.service.ButtonService;
import com.bizunited.nebula.rbac.sdk.event.ButtonEventListener;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ButtonServiceImpl
implements ButtonService {
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private CompetenceVoService competenceVoService;
    @Autowired
    private RoleVoCacheService roleVoService;
    @Autowired(required=false)
    private List<ButtonEventListener> buttonEventListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public ButtonEntity create(ButtonEntity button) {
        Date nowDate = new Date();
        button.setId(null);
        button.setCreateTime(nowDate);
        button.setModifyTime(nowDate);
        button.setSystem(false);
        button.setEffective(true);
        this.createValidation(button);
        this.buttonRepository.save((Object)button);
        ButtonVo buttonVo = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.buttonEventListeners)) {
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onCreated(buttonVo);
            }
        }
        return button;
    }

    private void createValidation(ButtonEntity button) {
        Validate.notNull((Object)((Object)button), (String)"\u4fdd\u5b58\u7684\u6309\u94ae\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)button.getTopCompetence()), (String)"\u83dc\u5355\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getTopCompetence().getId(), (String)"\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((button.getId() == null ? 1 : 0) != 0, (String)"\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u6709ID", (Object[])new Object[0]);
        CompetenceEntity competence = this.competenceRepository.findById(button.getTopCompetence().getId()).orElse(null);
        Validate.notNull((Object)((Object)competence), (String)"\u672a\u67e5\u8be2\u5230\u8be5\u83dc\u5355!", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCode(button.getCode());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void batchCreate(Set<ButtonEntity> buttons) {
        Validate.notEmpty(buttons, (String)"\u6279\u91cf\u521b\u5efa\u6309\u94ae\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6709\u4e00\u4e2a\u6309\u94ae!!", (Object[])new Object[0]);
        HashSet<ButtonEntity> buttonSet = new HashSet<ButtonEntity>();
        HashSet<String> codes = new HashSet<String>();
        for (ButtonEntity button : buttons) {
            this.createValidation(button);
            Validate.isTrue((!codes.contains(button.getCode()) ? 1 : 0) != 0, (String)"\u4f20\u5165\u6309\u94ae\u6570\u636e\uff08\u6309\u94ae\u4e1a\u52a1\u7f16\u53f7\uff09\u6709\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            codes.add(button.getCode());
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String account = "admin";
            if (authentication != null) {
                account = authentication.getName();
            }
            button.setCreateTime(new Date());
            button.setCreateAccount(account);
            button.setModifyTime(new Date());
            button.setModifyAccount(account);
            button.setSystem(false);
            buttonSet.add(button);
        }
        this.buttonRepository.saveAll(buttonSet);
        for (ButtonEntity button : buttonSet) {
            ButtonVo buttonVo = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (CollectionUtils.isEmpty(this.buttonEventListeners)) continue;
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onCreated(buttonVo);
            }
        }
    }

    @Override
    @Transactional
    public ButtonEntity update(ButtonEntity button) {
        this.updateValidation(button);
        ButtonEntity updateButton = this.buttonRepository.findById(button.getId()).orElse(null);
        Validate.notNull((Object)((Object)updateButton), (String)"\u672a\u5728\u6570\u636e\u5c42\u627e\u5230\u5bf9\u5e94\u7684\u6309\u94ae\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((updateButton.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u66f4\u65b0", (Object[])new Object[0]);
        if (button.getButtonDesc() != null) {
            updateButton.setButtonDesc(button.getButtonDesc());
        }
        updateButton.setName(button.getName());
        updateButton.setCode(button.getCode());
        updateButton.setModifyTime(new Date());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = "admin";
        if (authentication != null) {
            account = authentication.getName();
        }
        updateButton.setModifyAccount(account);
        this.buttonRepository.save((Object)updateButton);
        Set<RoleEntity> roles = updateButton.getRoles();
        HashSet tenantCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(roles)) {
            roles.forEach(item -> tenantCodes.add(item.getTenantCode()));
        }
        this.notifyCacheClear(tenantCodes, updateButton);
        return updateButton;
    }

    private void updateValidation(ButtonEntity button) {
        Validate.notBlank((CharSequence)button.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getName(), (String)"\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)button.getId(), (String)"\u4fee\u6539\u6570\u636e\u5fc5\u987b\u8981\u6709ID", (Object[])new Object[0]);
        long countByCode = this.buttonRepository.countByCodeWithoutId(button.getCode(), button.getId());
        Validate.isTrue((countByCode == 0L ? 1 : 0) != 0, (String)"\u6309\u94ae\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void notifyCacheClear(Set<String> tenantCodes, ButtonEntity button) {
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
        if (!CollectionUtils.isEmpty(tenantCodes)) {
            for (String tenantCode : tenantCodes) {
                this.roleVoService.notifyCacheRefresh(tenantCode);
            }
        }
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notNull((Object)id, (String)"\u5220\u9664\u5fc5\u987b\u8981\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)button), (String)"\u5220\u9664\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((button.getSystem() == false ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6309\u94ae\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        Set<RoleEntity> roles = button.getRoles();
        HashSet tenantCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(roles)) {
            roles.forEach(item -> tenantCodes.add(item.getTenantCode()));
        }
        this.buttonRepository.unbindAllByButtonId(id);
        this.buttonRepository.unbindAllRoleByButtonId(id);
        this.buttonRepository.delete((Object)button);
        if (!CollectionUtils.isEmpty(this.buttonEventListeners)) {
            ButtonVo buttonVo = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (ButtonEventListener buttonEventListener : this.buttonEventListeners) {
                buttonEventListener.onDeleted(buttonVo);
            }
        }
        this.notifyCacheClear(tenantCodes, button);
    }

    @Override
    @Transactional
    public void batchDelete(String[] ids) {
        Validate.isTrue((ids != null && ids.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8981\u5220\u9664\u7684\u6309\u94ae\u6280\u672f\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String id : ids) {
            this.deleteById(id);
        }
    }

    @Override
    @Transactional
    public void bindRole(String roleId, String[] buttonIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((buttonIds != null && buttonIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonId : buttonIds) {
            Optional opButton = this.buttonRepository.findById(buttonId);
            Validate.isTrue((boolean)opButton.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonId});
            long count = this.buttonRepository.countByRoleIdAndButtonId(roleId, buttonId);
            if (count != 0L) continue;
            this.buttonRepository.bindRole(roleId, buttonId);
        }
        RoleEntity currentRole = (RoleEntity)((Object)op.get());
        this.roleVoService.notifyCacheRefresh(currentRole.getTenantCode());
    }

    @Override
    @Transactional
    public void rebindRole(String roleId, String[] buttonIds) {
        String[] exsitButtonIds;
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RoleEntity currentRole = this.roleRepository.findById(roleId).orElse(null);
        Validate.notNull((Object)((Object)currentRole), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Set<ButtonEntity> buttons = this.buttonRepository.findByRoleId(roleId);
        if (!CollectionUtils.isEmpty(buttons) && (exsitButtonIds = (String[])buttons.stream().map(UuidEntity::getId).toArray(String[]::new)) != null) {
            String[] stringArray = exsitButtonIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String exsitButtonId = stringArray[i];
                this.buttonRepository.unbindRole(roleId, exsitButtonId);
            }
        }
        if (buttonIds != null) {
            for (String buttonId : buttonIds) {
                Optional opButton = this.buttonRepository.findById(buttonId);
                Validate.isTrue((boolean)opButton.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonId});
                this.buttonRepository.bindRole(roleId, buttonId);
            }
        }
        this.roleVoService.notifyCacheRefresh(currentRole.getTenantCode());
    }

    @Override
    @Transactional
    public void unbindRole(String roleId, String[] buttonIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((buttonIds != null && buttonIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String buttonId : buttonIds) {
            Optional opButton = this.buttonRepository.findById(buttonId);
            Validate.isTrue((boolean)opButton.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{buttonId});
            this.competenceRepository.unbindRole(roleId, buttonId);
        }
        RoleEntity currentRole = (RoleEntity)((Object)op.get());
        this.roleVoService.notifyCacheRefresh(currentRole.getTenantCode());
    }

    @Override
    @Transactional
    public void unbindAllRoles(String roleId) {
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Set<ButtonEntity> buttons = this.buttonRepository.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        String[] buttonIds = (String[])buttons.stream().map(UuidEntity::getId).toArray(String[]::new);
        this.unbindRole(roleId, buttonIds);
        RoleEntity currentRole = (RoleEntity)((Object)op.get());
        this.roleVoService.notifyCacheRefresh(currentRole.getTenantCode());
    }
}

