/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.internal;

import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.enums.NormalStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.dto.CompetenceConditionDto;
import com.bizunited.nebula.rbac.local.entity.ButtonEntity;
import com.bizunited.nebula.rbac.local.entity.CompetenceEntity;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.ButtonRepository;
import com.bizunited.nebula.rbac.local.repository.CompetenceRepository;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.local.service.CompetenceService;
import com.bizunited.nebula.rbac.sdk.event.CompetenceEventListener;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompetenceServiceImpl
implements CompetenceService {
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private ButtonRepository buttonRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CompetenceVoService competenceVoService;
    @Autowired(required=false)
    private List<CompetenceEventListener> competenceListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public CompetenceEntity create(CompetenceEntity comp) {
        this.currentCreate(comp);
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
        return comp;
    }

    private void currentCreate(CompetenceEntity comp) {
        CompetenceEntity parent;
        this.validCompetence(comp);
        if (comp.getViewItem().equals(NormalStatusEnum.ENABLE.getStatus())) {
            String code = comp.getCode();
            Validate.notNull((Object)code, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            long count = this.competenceRepository.countByCode(comp.getCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
        comp.setId(null);
        String account = this.findOpUser();
        comp.setMethods(comp.getMethods().toUpperCase());
        comp.setTstatus(NormalStatusEnum.ENABLE.getStatus());
        comp.setCreateTime(new Date());
        comp.setModifyTime(new Date());
        comp.setCreateAccount(account);
        comp.setModifyAccount(account);
        if (comp.getSortIndex() == null) {
            comp.setSortIndex(100);
        }
        if ((parent = comp.getParent()) != null) {
            String parentId = parent.getId();
            Validate.notBlank((CharSequence)parentId, (String)"\u521b\u5efa\u83dc\u5355\u65f6\uff0c\u53ef\u4ee5\u6307\u5b9a\u4e0a\u7ea7\u83dc\u5355\uff0c\u4f46\u6307\u5b9a\u7684\u4e0a\u7ea7\u83dc\u5355\u9700\u8981\u6307\u5b9a\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
            CompetenceEntity cParent = this.competenceRepository.findById("\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355").orElse(null);
            Validate.notNull((Object)((Object)cParent), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            Validate.isTrue((!parentId.equals(comp.getId()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            comp.setParent(parent);
        } else {
            comp.setParent(null);
        }
        this.competenceRepository.saveAndFlush((Object)comp);
        if (!CollectionUtils.isEmpty(this.competenceListeners)) {
            CompetenceVo competenceVo = (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)comp, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.competenceListeners.forEach(item -> item.onCreated(competenceVo));
        }
    }

    private void validCompetence(CompetenceEntity comp) {
        Validate.notNull((Object)((Object)comp), (String)"\u529f\u80fd\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String resource = comp.getResource();
        Validate.notNull((Object)resource, (String)"\u529f\u80fdURL\u4e32\u4e0d\u80fd\u4e3a\u7a7a! \u5982\u679c\u6ca1\u6709\u529f\u80fd\u7684url\uff0c\u8bf7\u4f20\u9012\u7a7a\u5b57\u7b26\u4e32!", (Object[])new Object[0]);
        String method = comp.getMethods();
        Validate.notBlank((CharSequence)method, (String)"\u65b9\u6cd5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String comment = comp.getComment();
        Validate.notBlank((CharSequence)comment, (String)"\u529f\u80fd\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)comp.getViewItem(), (String)"\u529f\u80fd\u9879\u662f\u5426\u663e\u793a\u5728\u83dc\u5355\u6811\u4e2d\u5fc5\u4f20", (Object[])new Object[0]);
        if (comp.getParent() != null) {
            Validate.notBlank((CharSequence)comp.getParent().getId(), (String)"\u8bbe\u7f6e\u4e0a\u7ea7\u83dc\u5355\u5fc5\u987b\u4f20\u5165\u4e0a\u7ea7\u83dc\u5355id", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public List<CompetenceEntity> create(List<CompetenceEntity> comps) {
        Validate.isTrue((comps != null && !comps.isEmpty() ? 1 : 0) != 0, (String)"\u6279\u91cf\u6dfb\u52a0\u529f\u80fd\u65f6\uff0c\u5fc5\u987b\u8fdb\u884c\u6279\u91cf\u4f20\u53c2", (Object[])new Object[0]);
        for (CompetenceEntity competence : comps) {
            this.currentCreate(competence);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
        return comps;
    }

    @Override
    @Transactional
    public CompetenceEntity update(CompetenceEntity comp) {
        Validate.notNull((Object)((Object)comp), (String)"\u5fc5\u987b\u4f20\u5165\u9700\u8981\u4fee\u6539\u7684\u529f\u80fd\u4fe1\u606f!!", (Object[])new Object[0]);
        String compId = comp.getId();
        Validate.notBlank((CharSequence)compId, (String)"\u9519\u8bef\u7684\u529f\u80fd\u4fe1\u606f\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validCompetence(comp);
        Optional op = this.competenceRepository.findById(compId);
        Validate.isTrue((boolean)op.isPresent(), (String)"id\u4e3a%s\u7684\u529f\u80fd\u5bf9\u8c61\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{compId});
        CompetenceEntity currentComp = (CompetenceEntity)((Object)op.get());
        if (comp.getViewItem().equals(NormalStatusEnum.ENABLE.getStatus())) {
            long count = this.competenceRepository.countByCommentAndViewItemAndExceptId(currentComp.getId(), comp.getComment(), comp.getViewItem());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u83dc\u5355\u5907\u6ce8\u540d\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u83dc\u5355\u540d!!", (Object[])new Object[0]);
        }
        String account = this.findOpUser();
        currentComp.setResource(comp.getResource());
        currentComp.setMethods(comp.getMethods());
        currentComp.setComment(comp.getComment());
        currentComp.setDescription(comp.getDescription());
        currentComp.setType(comp.getType());
        currentComp.setModifyAccount(account);
        currentComp.setModifyTime(new Date());
        if (comp.getSortIndex() == null) {
            currentComp.setSortIndex(100);
        } else {
            currentComp.setSortIndex(comp.getSortIndex());
        }
        currentComp.setIcon(comp.getIcon());
        currentComp.setModifyTime(new Date());
        currentComp.setMethods(currentComp.getMethods().toUpperCase());
        CompetenceEntity parent = comp.getParent();
        CompetenceEntity oldParent = currentComp.getParent();
        if (!(parent == null || oldParent != null && oldParent.getId().equals(parent.getId()))) {
            CompetenceEntity entity = this.competenceRepository.findById(parent.getId()).orElse(null);
            Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            Validate.isTrue((!parent.getId().equals(currentComp.getId()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5c06\u81ea\u8eab\u8bbe\u7f6e\u4e3a\u4e0a\u7ea7\u83dc\u5355", (Object[])new Object[0]);
            HashSet<String> compStack = new HashSet<String>();
            compStack.add(currentComp.getId());
            this.validCompetenceCircular(entity, compStack);
            currentComp.setParent(entity);
        } else if (parent == null) {
            currentComp.setParent(null);
        }
        this.competenceRepository.saveAndFlush((Object)currentComp);
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
        return comp;
    }

    private void validCompetenceCircular(CompetenceEntity competence, Set<String> compStack) {
        Validate.notNull((Object)((Object)competence), (String)"\u5fc5\u987b\u4f20\u5165\u83dc\u5355\u4fe1\u606f", (Object[])new Object[0]);
        CompetenceEntity parent = competence.getParent();
        if (parent == null) {
            return;
        }
        Validate.isTrue((!compStack.contains(parent.getId()) ? 1 : 0) != 0, (String)"\u5f62\u6210\u5faa\u73af\u4f9d\u8d56\uff0c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        compStack.add(parent.getId());
        this.validCompetenceCircular(parent, compStack);
    }

    @Override
    @Transactional
    public void updateStatus(String id, Boolean flag) {
        if (StringUtils.isEmpty((CharSequence)id) || flag == null) {
            throw new IllegalArgumentException("updateStatus\u64cd\u4f5c\u65f6\u53c2\u6570\u9519\u8bef\uff01");
        }
        this.recursiveUpdateStatus(id, flag);
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    private void recursiveUpdateStatus(String parentCompetenceId, Boolean flag) {
        Optional op = this.competenceRepository.findById(parentCompetenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        CompetenceEntity competenceEntity = (CompetenceEntity)((Object)op.get());
        if (Boolean.TRUE.equals(flag)) {
            competenceEntity.setTstatus(1);
        } else {
            competenceEntity.setTstatus(0);
        }
        competenceEntity.setModifyTime(new Date());
        this.competenceRepository.save((Object)competenceEntity);
        List<CompetenceEntity> childList = this.competenceRepository.findByParentId(parentCompetenceId);
        for (int index = 0; childList != null && index < childList.size(); ++index) {
            this.recursiveUpdateStatus(childList.get(index).getId(), flag);
        }
    }

    private String findOpUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String account = "admin";
        if (authentication != null) {
            account = authentication.getName();
        }
        return account;
    }

    @Override
    @Transactional
    public void bindRole(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u6280\u672f\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional opCompetence = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)opCompetence.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            long count = this.competenceRepository.countByRoleIdAndCompetenceId(roleId, competenceId);
            if (count != 0L) continue;
            this.competenceRepository.bindRole(roleId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void reBindRole(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u6280\u672f\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        List<CompetenceEntity> competences = this.competenceRepository.findByRoleId(roleId);
        if (!CollectionUtils.isEmpty(competences)) {
            String[] exsitCompetenceIds;
            String[] stringArray = exsitCompetenceIds = (String[])competences.stream().map(UuidEntity::getId).toArray(String[]::new);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String competenceId = stringArray[i];
                Optional optional = this.competenceRepository.findById(competenceId);
                Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
                this.competenceRepository.unbindRole(roleId, competenceId);
            }
        }
        if (competenceIds == null || competenceIds.length == 0) {
            return;
        }
        for (String competenceId : competenceIds) {
            Optional opCompetence = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)opCompetence.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            long count = this.competenceRepository.countByRoleIdAndCompetenceId(roleId, competenceId);
            if (count != 0L) continue;
            this.competenceRepository.bindRole(roleId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void unbindRole(String roleId, String[] competenceIds) {
        Validate.notBlank((CharSequence)roleId, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u89d2\u8272\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((competenceIds != null && competenceIds.length > 0 ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u548c\u89d2\u8272\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u529f\u80fd\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            Optional optional = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            this.competenceRepository.unbindRole(roleId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void unbindAllRoles(String roleId) {
        String[] competenceIds;
        Validate.notBlank((CharSequence)roleId, (String)"\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional op = this.roleRepository.findById(roleId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u89d2\u8272\u4fe1\u606f", (Object[])new Object[0]);
        List<CompetenceEntity> competences = this.competenceRepository.findByRoleId(roleId);
        if (CollectionUtils.isEmpty(competences)) {
            return;
        }
        for (String competenceId : competenceIds = (String[])competences.stream().map(UuidEntity::getId).toArray(String[]::new)) {
            Optional optional = this.competenceRepository.findById(competenceId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            this.competenceRepository.unbindRole(roleId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void bindButtons(String buttonId, String[] competenceIds) {
        Validate.notBlank((CharSequence)buttonId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.buttonRepository.findById(buttonId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceIds, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            CompetenceEntity opCompetence = this.competenceRepository.findById(competenceId).orElse(null);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u63a5\u53e3\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            long count = this.buttonRepository.countByCompetenceIdAndButtonId(buttonId, competenceId);
            if (count != 0L) continue;
            this.buttonRepository.bindCompetence(buttonId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void reBindButtons(String buttonId, String[] competenceIds) {
        Validate.notBlank((CharSequence)buttonId, (String)"\u6309\u94aeID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ButtonEntity button = this.buttonRepository.findById(buttonId).orElse(null);
        Validate.notNull((Object)((Object)button), (String)"\u6309\u94ae\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        this.buttonRepository.unbindAllByButtonId(buttonId);
        if (competenceIds != null && competenceIds.length > 0) {
            for (String competenceId : competenceIds) {
                CompetenceEntity opCompetence = this.competenceRepository.findById(competenceId).orElse(null);
                Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u529f\u80fd\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
                this.buttonRepository.bindCompetence(buttonId, competenceId);
            }
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void unbindButtons(String buttonId, String[] competenceIds) {
        Validate.notBlank((CharSequence)buttonId, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        Optional op = this.buttonRepository.findById(buttonId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u6309\u94ae\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notEmpty((Object[])competenceIds, (String)"\u8fdb\u884c\u6309\u94ae\u548c\u63a5\u53e3\u89e3\u7ed1\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u6309\u94ae\u7f16\u53f7!!", (Object[])new Object[0]);
        for (String competenceId : competenceIds) {
            CompetenceEntity opCompetence = this.competenceRepository.findById(competenceId).orElse(null);
            Validate.notNull((Object)((Object)opCompetence), (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u63a5\u53e3\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{competenceId});
            this.buttonRepository.unbindCompetence(buttonId, competenceId);
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    @Transactional
    public void deleteById(String competenceId) {
        Validate.notBlank((CharSequence)competenceId, (String)"\u5220\u9664\u529f\u80fd\u65f6\uff0c\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u5fc5\u987b\u4f20\u9012!!", (Object[])new Object[0]);
        Optional op = this.competenceRepository.findById(competenceId);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u529f\u80fd\u7f16\u53f7\u7684\u529f\u80fd\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570!!", (Object[])new Object[0]);
        CompetenceEntity currentCompetence = (CompetenceEntity)((Object)op.get());
        Set<RoleEntity> roles = currentCompetence.getRoles();
        Validate.isTrue((boolean)CollectionUtils.isEmpty(roles), (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u89d2\u8272\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        List<CompetenceEntity> childs = this.competenceRepository.findByParentId(competenceId);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(childs), (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5b58\u5728\u5b50\u7ea7\u529f\u80fd\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        Set<ButtonEntity> buttons = currentCompetence.getButtons();
        Validate.isTrue((!CollectionUtils.isEmpty(buttons) ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u529f\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u6309\u94ae\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664!!", (Object[])new Object[0]);
        this.competenceRepository.delete((Object)currentCompetence);
        if (!CollectionUtils.isEmpty(this.competenceListeners)) {
            CompetenceVo competenceVo = (CompetenceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)currentCompetence, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.competenceListeners.forEach(item -> item.onCreated(competenceVo));
        }
        String appCode = TenantUtils.getAppCode();
        this.competenceVoService.notifyCacheRefresh(appCode);
    }

    @Override
    public Page<CompetenceEntity> findByConditions(CompetenceConditionDto competence, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.competenceRepository.findByConditions(pageable, competence);
    }

    @Override
    public CompetenceEntity findByCommentAndViewItemAndParent(String comment, int viewItem, String parentId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{comment, parentId})) {
            return null;
        }
        CompetenceEntity competence = this.competenceRepository.findByCommentAndViewItemAndParent(comment, viewItem, parentId);
        return competence == null ? null : (CompetenceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceEntity.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    public CompetenceEntity findByCommentAndViewItemAndParentNull(String comment, int viewItem) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return null;
        }
        CompetenceEntity competence = this.competenceRepository.findByCommentAndViewItemAndNullParent(comment, viewItem);
        return competence == null ? null : (CompetenceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)competence, CompetenceEntity.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    public List<CompetenceEntity> findAll() {
        return this.competenceRepository.findAll();
    }

    @Override
    public long countByViewItem(int viewItem) {
        return this.competenceRepository.countByViewItem(viewItem);
    }

    @Override
    public long count() {
        return this.competenceRepository.count();
    }
}

