/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.entity.CompetenceEntity;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.CompetenceRepository;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.local.service.strategy.CompetenceQueryStrategy;
import com.bizunited.nebula.rbac.local.service.strategy.QueryByButtonCodeAndRoleCodes;
import com.bizunited.nebula.rbac.local.service.strategy.QueryByParentNull;
import com.bizunited.nebula.rbac.local.service.strategy.QueryByResourcesAndMethodAndRoleCodes;
import com.bizunited.nebula.rbac.local.service.strategy.QueryByViewItemAndRoleCodes;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.bizunited.nebula.rbac.sdk.service.ButtonVoService;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public class CompetenceVoServiceImpl
implements CompetenceVoService {
    @Autowired
    private CompetenceRepository competenceRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private ButtonVoService buttonVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private Redisson redisson;
    private volatile Thread flashingThread = null;
    private AtomicReference<Thread> atomicReference = new AtomicReference<Object>(null);
    private static Map<String, Map<String, CompetenceVo>> competencesCacheMapping = Maps.newConcurrentMap();
    private static ReentrantReadWriteLock competenceloadLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String appCode) {
        Validate.notBlank((CharSequence)appCode, (String)"\u8981\u6c42\u6e05\u7406\u529f\u80fd\u6811\u7f13\u5b58\u65f6\uff0c\u5fc5\u987b\u4f20\u5165appCode", (Object[])new Object[0]);
        ReentrantReadWriteLock.WriteLock writeLock = competenceloadLock.writeLock();
        try {
            writeLock.lock();
            Map<String, CompetenceVo> competencesCache = competencesCacheMapping.get(appCode);
            if (competencesCache != null) {
                competencesCache.clear();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void notifyCacheRefresh(String appCode) {
        Validate.notBlank((CharSequence)appCode, (String)"\u8981\u6c42\u6e05\u7406\u529f\u80fd\u6811\u7f13\u5b58\u65f6\uff0c\u5fc5\u987b\u4f20\u5165appCode", (Object[])new Object[0]);
        RTopic topic = this.redisson.getTopic("_ALL_COMPETENCE_NOTIFY");
        topic.publish((Object)appCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDetailsFromRepository() {
        String appCode = TenantUtils.getAppCode();
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        readLock.unlock();
        Thread currentThread = Thread.currentThread();
        boolean isFlashingThread = false;
        isFlashingThread = this.atomicReference.compareAndSet(null, currentThread);
        if (isFlashingThread) {
            this.flashingThread = currentThread;
        } else {
            Thread.yield();
        }
        if (!isFlashingThread) {
            while (this.flashingThread != null) {
                Thread.yield();
            }
            readLock.lock();
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = competenceloadLock.writeLock();
        try {
            writeLock.lock();
            ConcurrentMap competenceCacheMapping = Maps.newConcurrentMap();
            List allCompetences = this.competenceRepository.findAll();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)allCompetences) ? 1 : 0) != 0, (String)"\u83dc\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            List currentTopCompetences = allCompetences.stream().filter(e -> e.getViewItem() == 1).collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(currentTopCompetences) ? 1 : 0) != 0, (String)"\u53d1\u73b0\u9519\u8bef\u7684\u9876\u5c42\u83dc\u5355\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            ArrayList topCompetences = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(currentTopCompetences, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"parent"}));
            Validate.isTrue((boolean)topCompetences.stream().noneMatch(item -> StringUtils.isBlank((CharSequence)item.getCode())), (String)"\u53d1\u73b0\u9519\u8bef\u7684\u9876\u5c42\u83dc\u5355\u4fe1\u606f(\u6ca1\u6709\u552f\u4e00\u4e1a\u52a1\u7f16\u53f7)\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
            for (CompetenceVo topCompetence : topCompetences) {
                this.recursiveLoadCompetence(topCompetence);
                competenceCacheMapping.put(topCompetence.getCode(), topCompetence);
            }
            List currentCompetenceEntitys = allCompetences.stream().filter(e -> e.getViewItem() == 0).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentCompetenceEntitys)) {
                topCompetences = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(currentCompetenceEntitys, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                for (CompetenceVo currentCompetence : topCompetences) {
                    this.recursiveLoadCompetence(currentCompetence);
                    competenceCacheMapping.put(currentCompetence.getCode(), currentCompetence);
                }
            }
            competencesCacheMapping.put(appCode, competenceCacheMapping);
        }
        finally {
            this.atomicReference.compareAndSet(currentThread, null);
            this.flashingThread = null;
            writeLock.unlock();
            readLock.lock();
        }
    }

    private void recursiveLoadCompetence(CompetenceVo competence) {
        List<CompetenceEntity> childrens;
        List<RoleEntity> roles;
        String competenceId = competence.getId();
        Set buttonVos = this.buttonVoService.findByTopCompetenceId(competenceId);
        if (!CollectionUtils.isEmpty((Collection)buttonVos)) {
            competence.setButtons(buttonVos);
        }
        if (!CollectionUtils.isEmpty(roles = this.roleRepository.findByCompetenceId(competenceId))) {
            List roleCodes = roles.stream().map(item -> StringUtils.join((Object[])new String[]{item.getTenantCode(), "|", item.getRoleCode()})).distinct().collect(Collectors.toList());
            competence.setRoles(StringUtils.join(roleCodes, (String)","));
        }
        if (CollectionUtils.isEmpty(childrens = this.competenceRepository.findByParentId(competenceId))) {
            return;
        }
        LinkedHashSet childrenVos = Sets.newLinkedHashSet((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrens, CompetenceEntity.class, CompetenceVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"buttons"}));
        for (CompetenceVo childCompetence : childrenVos) {
            this.recursiveLoadCompetence(childCompetence);
            childCompetence.setParent(competence);
        }
        competence.setChildren((Set)childrenVos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CompetenceVo> findByViewItemAndRoleCodesAndStatus(Boolean viewItem, String tenantCode, String[] roleCodes, Integer status) {
        String appCode = TenantUtils.getAppCode();
        if (roleCodes == null || roleCodes.length == 0 || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, appCode})) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        QueryByViewItemAndRoleCodes competenceQueryStrategy = new QueryByViewItemAndRoleCodes(viewItem, isAdmin, tenantCode, roleCodes, status, this.rbacCustomProperties.getIgnoreMethodCheckRoles());
        LinkedHashSet results = Sets.newLinkedHashSet();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> topCompetences = competencesCacheMapping.get(appCode).values();
            List sortedTopCompetences = topCompetences.stream().filter(e -> e.getParent() == null || StringUtils.isBlank((CharSequence)e.getParent().getId())).sorted(Comparator.comparingInt(CompetenceVo::getSortIndex)).collect(Collectors.toList());
            for (CompetenceVo topCompetence : sortedTopCompetences) {
                CompetenceVo copyTopCompetence = this.recursiveQueryCompetenceForTree(competenceQueryStrategy, topCompetence);
                if (copyTopCompetence == null) continue;
                results.add(copyTopCompetence);
            }
        }
        finally {
            readLock.unlock();
        }
        return results;
    }

    public Set<CompetenceVo> findByViewItemAndCurrentAccount(Boolean viewItem) {
        String tenantCode = TenantUtils.getTenantCode();
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Collection authorities = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return null;
        }
        Set<String> roleCodes = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(roleCodes)) {
            return null;
        }
        return this.findByViewItemAndRoleCodesAndStatus(viewItem, tenantCode, roleCodes.toArray(new String[0]), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CompetenceVo> findByViewItemAndStatusAndParentNull(Boolean viewItem, String tenantCode, Integer status) {
        String appCode = TenantUtils.getAppCode();
        if (viewItem == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, appCode})) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        LinkedHashSet results = Sets.newLinkedHashSet();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> topCompetences = competencesCacheMapping.get(appCode).values();
            QueryByParentNull queryByParentNull = new QueryByParentNull(viewItem, tenantCode, status);
            List sortedTopCompetences = topCompetences.stream().filter(e -> e.getParent() == null || StringUtils.isBlank((CharSequence)e.getParent().getId())).sorted(Comparator.comparingInt(CompetenceVo::getSortIndex)).collect(Collectors.toList());
            for (CompetenceVo topCompetence : sortedTopCompetences) {
                CompetenceVo copyTopCompetence = this.recursiveQueryCompetenceForTree(queryByParentNull, topCompetence);
                if (copyTopCompetence == null) continue;
                results.add(copyTopCompetence);
            }
        }
        finally {
            readLock.unlock();
        }
        return results;
    }

    private CompetenceVo recursiveQueryCompetenceForTree(CompetenceQueryStrategy competenceQueryStrategy, CompetenceVo competence) {
        CompetenceVo copyCompetence = competenceQueryStrategy.filterCompetence(competence);
        if (copyCompetence == null) {
            return null;
        }
        Validate.isTrue((copyCompetence != competence ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u6811\u67e5\u8be2\u548c\u6784\u5efa\u65f6\uff0c\u5fc5\u987b\u4f7f\u7528\u4e2d\u62f7\u526f\u672c", (Object[])new Object[0]);
        Set buttons = competence.getButtons();
        LinkedHashSet copyButtons = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty((Collection)buttons)) {
            for (ButtonVo buttonVo : buttons) {
                ButtonVo copyButton = competenceQueryStrategy.filterButton(buttonVo);
                if (copyButton == null) continue;
                copyButtons.add(copyButton);
            }
        }
        copyCompetence.setButtons((Set)copyButtons);
        Set children = competence.getChildren();
        LinkedHashSet copyChildren = Sets.newLinkedHashSet();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (CompetenceVo child : children) {
                CompetenceVo copyChild = this.recursiveQueryCompetenceForTree(competenceQueryStrategy, child);
                if (copyChild == null) continue;
                copyChildren.add(copyChild);
            }
            copyCompetence.setChildren((Set)copyChildren);
        }
        return copyCompetence;
    }

    private boolean comfirmAdmin(String[] roleCodes) {
        boolean isAdmin = false;
        if (roleCodes != null && roleCodes.length > 0) {
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet((Object[])roleCodes));
            isAdmin = !CollectionUtils.isEmpty((Collection)intersections);
        }
        return isAdmin;
    }

    public Set<CompetenceVo> findByResource(String resource, Integer tstatus) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByResources(new String[]{resource}, null, tstatus, null, null, results);
        return results;
    }

    public Set<CompetenceVo> findByResourceLike(String resource, Integer status) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByResources(new String[]{resource}, null, status, null, null, results);
        return results;
    }

    public Set<CompetenceVo> findByResources(String[] resources, String tenantCode, String[] roleCodes) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByResources(resources, null, null, tenantCode, roleCodes, results);
        return results;
    }

    public CompetenceVo findByResourceAndMethods(String resource, String methods, Integer status) {
        if (StringUtils.isBlank((CharSequence)resource)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByResources(new String[]{resource}, methods, status, null, null, results);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return (CompetenceVo)results.iterator().next();
    }

    public Set<CompetenceVo> findByResourcesAndCurrentAccount(String[] resources) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByResources(resources, null, null, tenantCode, null, results);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findByResources(String[] resources, String method, Integer status, String tenantCode, String[] roleCodes, Set<CompetenceVo> results) {
        String appCode = TenantUtils.getAppCode();
        if (resources == null || resources.length == 0) {
            return;
        }
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        QueryByResourcesAndMethodAndRoleCodes competenceQueryStrategy = new QueryByResourcesAndMethodAndRoleCodes(resources, false, method, status, tenantCode, roleCodes, isAdmin, this.rbacCustomProperties.getIgnoreMethodCheckRoles());
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> topCompetences = competencesCacheMapping.get(appCode).values();
            List sortedTopCompetences = topCompetences.stream().sorted((source, target) -> source.getSortIndex() - target.getSortIndex()).collect(Collectors.toList());
            for (CompetenceVo topCompetence : sortedTopCompetences) {
                this.recursiveQueryCompetenceForList(competenceQueryStrategy, topCompetence, results);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public Set<CompetenceVo> findByButtonCode(String buttonCode) {
        if (StringUtils.isBlank((CharSequence)buttonCode)) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByButtonCodeAndRoleCodes(buttonCode, null, null, null, results);
        return results;
    }

    public Set<CompetenceVo> findByRoleCodes(String tenantCode, String[] roleCodes) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || roleCodes == null || roleCodes.length == 0) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByButtonCodeAndRoleCodes(null, tenantCode, roleCodes, null, results);
        return results;
    }

    public Set<CompetenceVo> findByRoleCodesAndParentNull(String tenantCode, String[] roleCodes) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || roleCodes == null || roleCodes.length == 0) {
            return null;
        }
        LinkedHashSet results = Sets.newLinkedHashSet();
        this.findByButtonCodeAndRoleCodes(null, tenantCode, roleCodes, true, results);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            return Sets.newLinkedHashSet((Iterable)results.stream().filter(item -> item.getParent() == null).collect(Collectors.toList()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findByButtonCodeAndRoleCodes(String buttonCode, String tenantCode, String[] roleCodes, Boolean viewItem, Set<CompetenceVo> results) {
        String appCode = TenantUtils.getAppCode();
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        QueryByButtonCodeAndRoleCodes competenceQueryStrategy = new QueryByButtonCodeAndRoleCodes(tenantCode, roleCodes, viewItem, buttonCode, isAdmin, roleCodes);
        ReentrantReadWriteLock.ReadLock readLock = competenceloadLock.readLock();
        try {
            readLock.lock();
            if (CollectionUtils.isEmpty(competencesCacheMapping.get(appCode))) {
                this.findDetailsFromRepository();
            }
            Collection<CompetenceVo> topCompetences = competencesCacheMapping.get(appCode).values();
            List sortedTopCompetences = topCompetences.stream().sorted((source, target) -> source.getSortIndex() - target.getSortIndex()).collect(Collectors.toList());
            for (CompetenceVo topCompetence : sortedTopCompetences) {
                this.recursiveQueryCompetenceForList(competenceQueryStrategy, topCompetence, results);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void recursiveQueryCompetenceForList(CompetenceQueryStrategy competenceQueryStrategy, CompetenceVo competence, Set<CompetenceVo> queryResult) {
        Set children;
        CompetenceVo copyCompetence = competenceQueryStrategy.filterCompetence(competence);
        if (copyCompetence != null) {
            Validate.isTrue((copyCompetence != competence ? 1 : 0) != 0, (String)"\u8fdb\u884c\u529f\u80fd\u6811\u67e5\u8be2\u548c\u6784\u5efa\u65f6\uff0c\u5fc5\u987b\u4f7f\u7528\u4e2d\u62f7\u526f\u672c", (Object[])new Object[0]);
            queryResult.add(copyCompetence);
        }
        if (copyCompetence != null) {
            Set buttons = competence.getButtons();
            LinkedHashSet copyButtons = Sets.newLinkedHashSet();
            if (!CollectionUtils.isEmpty((Collection)buttons)) {
                for (ButtonVo buttonVo : buttons) {
                    ButtonVo copyButton = competenceQueryStrategy.filterButton(buttonVo);
                    if (copyButton == null) continue;
                    copyButtons.add(copyButton);
                }
            }
            copyCompetence.setButtons((Set)copyButtons);
        }
        if (!CollectionUtils.isEmpty((Collection)(children = competence.getChildren()))) {
            for (CompetenceVo child : children) {
                this.recursiveQueryCompetenceForList(competenceQueryStrategy, child, queryResult);
            }
        }
    }
}

