/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.notifier;

import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.bizunited.nebula.rbac.sdk.service.CompetenceVoService;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import com.bizunited.nebula.security.sdk.event.AuthenticationRbacEventListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class AuthenticationRbacEventListenerImpl
implements AuthenticationRbacEventListener {
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private CompetenceVoService competenceVoService;

    public Set<String> onRequestIgnoreMethodCheckRoles() {
        Object[] ignoreMethodCheckRoles = this.rbacCustomProperties.getIgnoreMethodCheckRoles();
        if (ignoreMethodCheckRoles == null || ignoreMethodCheckRoles.length == 0) {
            return null;
        }
        return Sets.newHashSet((Object[])ignoreMethodCheckRoles);
    }

    public Set<String> onRequestRoleCodes(List<RequestMappingInfo> matchedRequestMappings, String tenantCode, String currentMethod) {
        HashSet resultRoleCodes = Sets.newHashSet();
        ArrayList currentCompetences = Lists.newArrayList();
        for (RequestMappingInfo requestMappingInfo : matchedRequestMappings) {
            Set resources = requestMappingInfo.getPatternsCondition().getPatterns();
            if (resources == null || resources.isEmpty()) continue;
            for (String resource : resources) {
                Set cacheCompetences = this.competenceVoService.findByResource(resource, Integer.valueOf(1));
                if (cacheCompetences == null || cacheCompetences.isEmpty()) continue;
                currentCompetences.addAll(cacheCompetences);
            }
        }
        if (currentCompetences.isEmpty()) {
            resultRoleCodes.add("ANONYMOUS");
            return resultRoleCodes;
        }
        String matchedFix = tenantCode + "|";
        for (CompetenceVo competence : currentCompetences) {
            String[] tenantAndRoleCodeArray;
            String tenantAndRoleCodes;
            String methods = competence.getMethods();
            if (methods.indexOf(currentMethod) == -1 || StringUtils.isBlank((CharSequence)(tenantAndRoleCodes = competence.getRoles())) || (tenantAndRoleCodeArray = StringUtils.split((String)tenantAndRoleCodes, (String)",")) == null || tenantAndRoleCodeArray.length == 0) continue;
            for (String tenantAndRoleCode : tenantAndRoleCodeArray) {
                if (StringUtils.indexOf((CharSequence)tenantAndRoleCode, (CharSequence)matchedFix) != 0) continue;
                String currentRoleCode = StringUtils.substringAfterLast((String)tenantAndRoleCode, (String)matchedFix);
                resultRoleCodes.add(currentRoleCode);
            }
        }
        return resultRoleCodes;
    }
}

