/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.notifier;

import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CacheRedisMessageForRoleIdentityListenerImpl")
public class CacheRedisMessageForRoleIdentityListenerImpl
implements MessageListener<String> {
    @Autowired
    private RoleVoCacheService roleVoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForRoleIdentityListenerImpl.class);

    public void onMessage(CharSequence channel, String tenantCodeAndRoleCode) {
        LOGGER.info("tenant role identity notifing ......");
        String[] tenantCodeAndRoleCodeArray = StringUtils.split((String)tenantCodeAndRoleCode, (String)"|");
        if (tenantCodeAndRoleCodeArray == null || tenantCodeAndRoleCodeArray.length != 2) {
            LOGGER.warn("tenant role identity string format error ......");
            return;
        }
        String tenantCode = tenantCodeAndRoleCodeArray[0];
        String roleCode = tenantCodeAndRoleCodeArray[1];
        if (!StringUtils.isBlank((CharSequence)tenantCode)) {
            this.roleVoService.clearCache(tenantCode, roleCode);
        }
    }
}

