/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.strategy;

import com.bizunited.nebula.rbac.local.service.strategy.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.rbac.local.service.strategy.CompetenceQueryStrategy;
import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class QueryByResourcesAndMethodAndRoleCodes
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private String[] resources;
    private boolean like;
    private String method;
    private Integer status;
    private String tenantCode;
    private String[] roleCodes;
    private boolean isAdmin;
    private String[] ignoreMethodCheckRoles;

    public QueryByResourcesAndMethodAndRoleCodes(String[] resources, boolean like, String method, Integer status, String tenantCode, String[] roleCodes, boolean isAdmin, String[] ignoreMethodCheckRoles) {
        this.resources = resources;
        if (resources == null || resources.length == 0) {
            throw new IllegalArgumentException("\u8fdb\u884c\u83dc\u5355/\u529f\u80fd\u5339\u914d\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u57fa\u4e8e\u6bd4\u8f83\u7684\u529f\u80fd\u4fe1\u606f");
        }
        this.like = like;
        this.method = method;
        this.status = status;
        this.tenantCode = tenantCode;
        this.roleCodes = roleCodes;
        this.isAdmin = isAdmin;
        this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
    }

    @Override
    public CompetenceVo filterCompetence(CompetenceVo competence) {
        String targetResource = competence.getResource();
        String targetMethods = competence.getMethods();
        Integer targetStatus = competence.getTstatus();
        String targetRoles = competence.getRoles();
        boolean canContinue = false;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{targetResource, targetMethods}) || targetStatus == null) {
            return null;
        }
        if (!StringUtils.isBlank((CharSequence)this.method) && StringUtils.indexOf((CharSequence)targetMethods, (CharSequence)this.method) == -1) {
            return null;
        }
        if (this.status != null && this.status.intValue() != targetStatus.intValue()) {
            return null;
        }
        CompetenceVo copyCompetence = this.copyCompetence(competence);
        Object[] matchedRolesReuslt = new String[]{};
        for (String resource : this.resources) {
            if (!this.like && StringUtils.equals((CharSequence)resource, (CharSequence)targetResource)) {
                canContinue = true;
                break;
            }
            if (!this.like || StringUtils.indexOf((CharSequence)resource, (CharSequence)targetResource) == -1) continue;
            canContinue = true;
            break;
        }
        if (!canContinue) {
            return null;
        }
        if (!this.isAdmin && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
            if (!StringUtils.isEmpty((CharSequence)targetRoles)) {
                ArrayList matchTargetRoles = Lists.newArrayList();
                for (String roleCode : this.roleCodes) {
                    matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
                }
                String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
                String[] matchedRoles = (String[])Arrays.stream(StringUtils.split((String)targetRoles, (String)",")).filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
                if (matchedRoles == null || matchedRoles.length == 0) {
                    canContinue = false;
                } else {
                    matchedRolesReuslt = (String[])Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).toArray(String[]::new);
                }
            } else {
                canContinue = false;
            }
        } else if (this.isAdmin) {
            matchedRolesReuslt = this.ignoreMethodCheckRoles;
        }
        if (!canContinue) {
            return null;
        }
        if (matchedRolesReuslt != null && matchedRolesReuslt.length > 0) {
            copyCompetence.setRoles(StringUtils.join((Object[])matchedRolesReuslt, (String)","));
        }
        return copyCompetence;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ButtonVo filterButton(ButtonVo button) {
        void var5_9;
        boolean effective = button.getEffective();
        Set targetRoles = button.getRoles();
        if (this.status != null && this.status != (effective ? 1 : 0)) {
            return null;
        }
        ButtonVo copyButton = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        if (!this.isAdmin && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
            if (CollectionUtils.isEmpty((Collection)targetRoles)) return null;
            ArrayList matchTargetRoles = Lists.newArrayList();
            for (String roleCode : this.roleCodes) {
                matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
            }
            String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
            String[] matchedRoles = (String[])targetRoles.stream().filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
            if (matchedRoles == null || matchedRoles.length == 0) {
                return null;
            }
            Set set = Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
        } else if (this.isAdmin) {
            HashSet hashSet = Sets.newHashSet((Object[])this.ignoreMethodCheckRoles);
        } else {
            Set set = targetRoles;
        }
        copyButton.setRoles((Set)var5_9);
        return copyButton;
    }
}

