/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.strategy;

import com.bizunited.nebula.rbac.local.service.strategy.AbstractCompetenceQueryStrategy;
import com.bizunited.nebula.rbac.local.service.strategy.CompetenceQueryStrategy;
import com.bizunited.nebula.rbac.sdk.vo.ButtonVo;
import com.bizunited.nebula.rbac.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class QueryByViewItemAndRoleCodes
extends AbstractCompetenceQueryStrategy
implements CompetenceQueryStrategy {
    private Boolean viewItem;
    private boolean isAdmin;
    private String tenantCode;
    private String[] roleCodes;
    private Integer status;
    private String[] ignoreMethodCheckRoles;

    public QueryByViewItemAndRoleCodes(Boolean viewItem, boolean isAdmin, String tenantCode, String[] roleCodes, Integer status, String[] ignoreMethodCheckRoles) {
        this.viewItem = viewItem;
        this.isAdmin = isAdmin;
        this.tenantCode = tenantCode;
        this.roleCodes = roleCodes;
        this.status = status;
        this.ignoreMethodCheckRoles = ignoreMethodCheckRoles;
    }

    @Override
    public CompetenceVo filterCompetence(CompetenceVo competence) {
        Integer competenceStatus = competence.getTstatus();
        Integer competenceViewItem = competence.getViewItem();
        boolean canContinue = true;
        if (this.viewItem != null && this.viewItem.booleanValue() && competenceViewItem != 1) {
            canContinue = false;
        }
        if (this.status != null && this.status == 1 && competenceStatus != 1) {
            canContinue = false;
        }
        if (!canContinue) {
            return null;
        }
        CompetenceVo copyCompetence = this.copyCompetence(competence);
        Object[] matchedRolesReuslt = new String[]{};
        if (!this.isAdmin) {
            String competenceRoles = competence.getRoles();
            if (!StringUtils.isEmpty((CharSequence)competenceRoles) && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
                ArrayList matchTargetRoles = Lists.newArrayList();
                for (String roleCode : this.roleCodes) {
                    matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
                }
                String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
                String[] matchedRoles = (String[])Arrays.stream(StringUtils.split((String)competenceRoles, (String)",")).filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
                if (matchedRoles == null || matchedRoles.length == 0) {
                    canContinue = false;
                } else {
                    matchedRolesReuslt = (String[])Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).toArray(String[]::new);
                }
            } else {
                canContinue = false;
            }
        } else {
            matchedRolesReuslt = this.ignoreMethodCheckRoles;
        }
        if (!canContinue) {
            return null;
        }
        copyCompetence.setRoles(StringUtils.join((Object[])matchedRolesReuslt, (String)","));
        return copyCompetence;
    }

    @Override
    public ButtonVo filterButton(ButtonVo button) {
        boolean effective = button.getEffective();
        boolean canContinue = true;
        if (this.status != null && this.status == 1 && !effective) {
            canContinue = false;
        }
        if (!canContinue) {
            return null;
        }
        ButtonVo copyButton = (ButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)button, ButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set<Object> matchedRolesReuslt = Sets.newLinkedHashSet();
        if (!this.isAdmin) {
            Set buttonRoles = button.getRoles();
            if (!CollectionUtils.isEmpty((Collection)buttonRoles) && StringUtils.isNotBlank((CharSequence)this.tenantCode) && this.roleCodes != null && this.roleCodes.length > 0) {
                ArrayList matchTargetRoles = Lists.newArrayList();
                for (String roleCode : this.roleCodes) {
                    matchTargetRoles.add(StringUtils.join((Object[])new String[]{this.tenantCode, "|", roleCode}));
                }
                String[] matchTargetRoleArray = matchTargetRoles.toArray(new String[0]);
                String[] matchedRoles = (String[])buttonRoles.stream().filter(item -> StringUtils.equalsAny((CharSequence)item, (CharSequence[])matchTargetRoleArray)).toArray(String[]::new);
                if (matchedRoles == null || matchedRoles.length == 0) {
                    canContinue = false;
                } else {
                    matchedRolesReuslt = Arrays.stream(matchedRoles).map(item -> StringUtils.split((String)item, (String)"|")[1]).collect(Collectors.toSet());
                }
            } else {
                canContinue = false;
            }
        } else {
            matchedRolesReuslt = Sets.newHashSet((Object[])this.ignoreMethodCheckRoles);
        }
        copyButton.setRoles((Set)matchedRolesReuslt);
        return copyButton;
    }
}

