/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.init;

import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import java.util.Date;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleProcessEnvironmentInit
implements InitProcessEnvironmentService {
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private RoleRepository roleRepository;

    public boolean doInitForAppCode(String appCode) {
        return true;
    }

    @Transactional
    public void initForAppCode(String appCode) {
        String[] superRoleCodes = this.rbacCustomProperties.getIgnoreMethodCheckRoles();
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        String defaultTenantCode = "default";
        for (String superRoleCode : superRoleCodes) {
            Validate.matchesPattern((CharSequence)superRoleCode, (String)pattern, (String)"\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u53d1\u73b0boot\u7684yml\u914d\u7f6e\u8bbe\u5b9a\u4e86\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272[%s]\uff0c\u4f46\u662f\u8be5\u89d2\u8272\u7684\u7f16\u7801\u4e0d\u7b26\u5408\u8981\u6c42\uff08\u53ea\u80fd\u7531\u5b50\u6bcd\u548c\u6570\u5b57\u7ec4\u6210\uff0c\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6240\u6709\u5b57\u6bcd\u9700\u8981\u5927\u5199\uff09\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u540e\u518d\u91cd\u542f\uff01\uff01", (Object[])new Object[0]);
            RoleEntity exsitRole = this.roleRepository.findByTenantCodeAndRoleCode(defaultTenantCode, superRoleCode);
            if (exsitRole != null) continue;
            RoleEntity superRole = new RoleEntity();
            Date now = new Date();
            superRole.setComment(StringUtils.join((Object[])new String[]{"\u8d85\u7ea7\u7ba1\u7406\u5458", superRoleCode}));
            superRole.setCreateAccount("admin");
            superRole.setCreateTime(now);
            superRole.setModifyAccount("admin");
            superRole.setModifyTime(now);
            superRole.setDefaultUrl("");
            superRole.setIsDeny(true);
            superRole.setRoleCode(superRoleCode);
            superRole.setRoleType("");
            superRole.setTenantCode(defaultTenantCode);
            superRole.setTstatus(1);
            this.roleRepository.save((Object)superRole);
        }
    }
}

