/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.local.service.RoleService;
import com.bizunited.nebula.rbac.sdk.event.RoleEventListener;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RoleVoServiceImpl
implements RoleVoService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleVoCacheService roleVoService;
    @Autowired(required=false)
    private List<RoleEventListener> roleEventListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public RoleVo create(RoleVo roleVo) {
        Validate.notNull((Object)roleVo, (String)"\u6dfb\u52a0\u64cd\u4f5c\u65f6\uff0c\u89d2\u8272\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        RoleEntity targetRole = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        targetRole = this.roleService.create(targetRole);
        roleVo.setId(targetRole.getId());
        roleVo.setRoleCode(targetRole.getRoleCode());
        roleVo.setCreateTime(targetRole.getCreateTime());
        roleVo.setCreateAccount(targetRole.getCreateAccount());
        roleVo.setModifyTime(targetRole.getModifyTime());
        roleVo.setModifyAccount(targetRole.getModifyAccount());
        if (CollectionUtils.isEmpty(this.roleEventListeners)) {
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onCreated(roleVo);
            }
        }
        String tenantCode = TenantUtils.getTenantCode();
        this.roleVoService.notifyCacheRefresh(tenantCode);
        return roleVo;
    }

    @Transactional
    public RoleVo update(RoleVo roleVo) {
        Validate.notNull((Object)roleVo, (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u89d2\u8272\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        RoleEntity targetRole = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        targetRole = this.roleService.update(targetRole);
        roleVo.setModifyTime(targetRole.getModifyTime());
        roleVo.setModifyAccount(targetRole.getModifyAccount());
        if (CollectionUtils.isEmpty(this.roleEventListeners)) {
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onUpdate(roleVo);
            }
        }
        this.roleVoService.notifyCacheRefresh(targetRole.getTenantCode());
        return roleVo;
    }

    @Transactional
    public void deleteByRoleCodes(String[] roleCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notEmpty((Object[])roleCodes, (String)"\u5220\u9664\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        for (String roleCode : roleCodes) {
            RoleVo roleVo = this.roleVoService.findByTenantCodeAndRoleCode(tenantCode, roleCode);
            Validate.notNull((Object)roleVo, (String)"\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664", (Object[])new Object[0]);
            this.roleRepository.deleteById(roleVo.getId());
            if (!CollectionUtils.isEmpty(this.roleEventListeners)) continue;
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onDeleted(roleVo);
            }
        }
        this.roleVoService.notifyCacheRefresh(tenantCode);
    }
}

