/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.sdk.config.RbacCustomProperties;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/roles"})
public class RoleVoCacheController
extends BaseController {
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private RoleVoCacheService roleVoCacheService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleVoCacheController.class);

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49,\u56e0\u4e3a\u6709\u4e3b\u526f\u5c97\u4f4d\u4e4b\u5206\uff0c\u5728\u67e5\u8be2\u7528\u6237\u7684\u89d2\u8272\u7528\u4e8e\u6743\u9650\u9a8c\u8bc1\u65f6\uff0c\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272\u53ea\u4f1a\u67e5\u8be2\u4e3b\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272\uff0c\u7528\u6237\u89d2\u8272\u7ef4\u62a4\u65f6\uff0c\u5219\u8fd4\u56de\u7528\u6237\u6240\u6709\u5c97\u4f4d\u7ed1\u5b9a\u7684\u89d2\u8272")
    @RequestMapping(value={"/findByAccount"}, method={RequestMethod.GET})
    public ResponseModel findByAccount(@ApiParam(value="\u6307\u5b9a\u7684\u4eba\u5458\u6570\u636e\u7f16\u53f7") @RequestParam String account) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set roles = this.roleVoCacheService.findByTenantCodeAndUserAccount(tenantCode, account);
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\uff0c\u67e5\u8be2\u5f53\u524d\u7528\u6237\u5177\u6709\u7684\u89d2\u8272\u3002\u8fd9\u4e9b\u89d2\u8272\u5305\u62ec\u4e86\u6240\u6709\u6765\u6e90\u4e8e\u4e0a\u5c42\u4e1a\u52a1\u6a21\u5757\u7684\u89d2\u8272\u7ed1\u5b9a")
    @GetMapping(value={"/findByCurrentUser"})
    public ResponseModel findByCurrentUser(Principal principal) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set roles = this.roleVoCacheService.findByTenantCodeAndUserAccount(tenantCode, principal.getName());
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u4e0e\u79df\u6237\u7f16\u53f7\u67e5\u8be2\u89d2\u8272\u4fe1\u606f\uff1a\u6ce8\u610f\u53ea\u67e5\u8be2\u5f53\u524d\u64cd\u4f5c\u8005\u6240\u5728\u79df\u6237\u7684\u8303\u56f4")
    @GetMapping(value={"/findByRoleCodes"})
    public ResponseModel findByTenantCodeAndRoleCodes(@ApiParam(value="\u53ef\u4ee5\u4f20\u5165\u7684\u591a\u4e2a\u89d2\u8272\u4e1a\u52a1\u7f16\u53f7") @RequestParam(value="roleCodes") String[] roleCodes) {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set roles = this.roleVoCacheService.findByTenantCodeAndRoleCodes(tenantCode, (Set)Sets.newHashSet((Object[])roleCodes));
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u7ed9\u5b9a\u4e00\u6279\u89d2\u8272\u540d\uff0c\u7cfb\u7edf\u4f1a\u8fd4\u56de\u8fd9\u6279\u89d2\u8272\u540d\u4e2d\uff0c\u662f\u5426\u6709\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u89d2\u8272\u62e5\u6709\u7ba1\u7406\u5458\u6027\u8d28\u7684\u89d2\u8272\u3002\u800c\u5224\u5b9a\u5177\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u6027\u8d28\u89d2\u8272\u7684\u7528\u6237\u4f1a\u88ab\u8fd4\u56de", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5df2\u62e5\u6709\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u5305\u62ec\u81ea\u5df1\u7ed1\u5b9a\u7684\uff0c\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784\u7684\uff0c\u6240\u5c5e\u7528\u6237\u7ec4\u7684\uff0c\u751a\u81f3\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7684\uff0c\u7b49\u7b49")
    @GetMapping(value={"/findByIgnoreRoles"})
    public ResponseModel findByIgnoreRoles(@ApiParam(value="\u5f53\u524d\u9700\u8981\u9a8c\u8bc1\u7684\u662f\u5426\u5177\u6709\u672c\u5730\u8d85\u7ea7\u7ba1\u7406\u5458") @RequestParam(name="roleCodes") String[] roleCodes) {
        try {
            Validate.isTrue((roleCodes != null && roleCodes.length > 0 ? 1 : 0) != 0, (String)"\u8981\u8fdb\u884c\u5224\u5b9a\u7684\u89d2\u8272\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet((Object[])roleCodes));
            if (intersections == null || intersections.isEmpty()) {
                return this.buildHttpResult();
            }
            JSONArray results = new JSONArray();
            for (String item : intersections) {
                results.add((Object)item);
            }
            return this.buildHttpResult(results);
        }
        catch (RuntimeException e) {
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u6811\u72b6\u5173\u7cfb\uff08\u6811\u5f62\u7684\u67e5\u8be2\u6682\u65f6\u4e0d\u80fd\u4f7f\u7528\uff0c\u6709\u9700\u6c42\u540e\u518d\u8fdb\u884c\u5b8c\u5584\uff09")
    @GetMapping(value={"/findRoleTree"})
    public ResponseModel findRoleTree() {
        try {
            String tenantCode = TenantUtils.getTenantCode();
            Set roles = this.roleVoCacheService.findRoleTree(tenantCode);
            return this.buildHttpResult(roles);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

