/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.RoleRepository;
import com.bizunited.nebula.rbac.local.service.RoleService;
import com.bizunited.nebula.rbac.sdk.event.RoleCopyEventListener;
import com.bizunited.nebula.rbac.sdk.event.RoleEventListener;
import com.bizunited.nebula.rbac.sdk.service.RoleVoCacheService;
import com.bizunited.nebula.rbac.sdk.service.RoleVoService;
import com.bizunited.nebula.rbac.sdk.vo.RoleVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class RoleVoServiceImpl
implements RoleVoService {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleVoCacheService roleVoCacheService;
    @Autowired(required=false)
    @Lazy
    private List<RoleEventListener> roleEventListeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<RoleCopyEventListener> roleCopyEventListener;

    @Transactional
    public RoleVo create(RoleVo roleVo) {
        Validate.notNull((Object)roleVo, (String)"\u6dfb\u52a0\u64cd\u4f5c\u65f6\uff0c\u89d2\u8272\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Date validEndTime = roleVo.getValidEndTime();
        Date validStartTime = roleVo.getValidStartTime();
        if (validStartTime != null && validEndTime != null) {
            Validate.isTrue((boolean)validEndTime.after(validStartTime), (String)"\u89d2\u8272\u8bbe\u5b9a\u4e86\u6709\u6548\u65f6\u95f4\uff0c\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5728\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e4b\u540e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
        RoleEntity targetRole = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        targetRole = this.roleService.create(targetRole);
        roleVo.setId(targetRole.getId());
        roleVo.setRoleCode(targetRole.getRoleCode());
        roleVo.setCreateTime(targetRole.getCreateTime());
        roleVo.setCreateAccount(targetRole.getCreateAccount());
        roleVo.setModifyTime(targetRole.getModifyTime());
        roleVo.setModifyAccount(targetRole.getModifyAccount());
        roleVo.setValidEndTime(validEndTime);
        roleVo.setValidStartTime(validStartTime);
        roleVo.setTenantCode(targetRole.getTenantCode());
        if (!CollectionUtils.isEmpty(this.roleEventListeners)) {
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onCreated(roleVo);
            }
        }
        String tenantCode = TenantUtils.getTenantCode();
        this.roleVoCacheService.notifyCacheRefresh(tenantCode);
        return roleVo;
    }

    @Transactional
    public RoleVo update(RoleVo roleVo) {
        Validate.notNull((Object)roleVo, (String)"\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u89d2\u8272\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Date validEndTime = roleVo.getValidEndTime();
        Date validStartTime = roleVo.getValidStartTime();
        if (validStartTime != null && validEndTime != null) {
            Validate.isTrue((boolean)validEndTime.after(validStartTime), (String)"\u89d2\u8272\u8bbe\u5b9a\u4e86\u6709\u6548\u65f6\u95f4\uff0c\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5728\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e4b\u540e\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
        RoleEntity targetRole = (RoleEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)roleVo, RoleEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        targetRole = this.roleService.update(targetRole);
        roleVo.setValidEndTime(validEndTime);
        roleVo.setValidStartTime(validStartTime);
        roleVo.setModifyTime(targetRole.getModifyTime());
        roleVo.setModifyAccount(targetRole.getModifyAccount());
        RoleVo oldRole = this.roleVoCacheService.findByTenantCodeAndRoleCode(targetRole.getTenantCode(), targetRole.getRoleCode());
        if (!CollectionUtils.isEmpty(this.roleEventListeners)) {
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onUpdate(roleVo, oldRole);
            }
        }
        this.roleVoCacheService.notifyCacheRefresh(targetRole.getTenantCode());
        return roleVo;
    }

    @Transactional
    public void deleteByRoleCodes(String[] roleCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notEmpty((Object[])roleCodes, (String)"\u5220\u9664\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]);
        for (String roleCode : roleCodes) {
            RoleEntity role = this.roleRepository.findByTenantCodeAndRoleCode(tenantCode, roleCode);
            Validate.notNull((Object)((Object)role), (String)"\u81f3\u5c11\u6709\u4e00\u4e2a\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664", (Object[])new Object[0]);
            this.roleRepository.deleteById(role.getId());
            RoleVo currentRoleVo = (RoleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)role, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (CollectionUtils.isEmpty(this.roleEventListeners)) continue;
            for (RoleEventListener roleEventListener : this.roleEventListeners) {
                roleEventListener.onDeleted(currentRoleVo);
            }
        }
        this.roleVoCacheService.notifyCacheRefresh(tenantCode);
    }

    public RoleVo findByTenantCodeAndRoleCode(String tenantCode, String roleCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, roleCode})) {
            return null;
        }
        RoleEntity roleEntity = this.roleRepository.findByTenantCodeAndRoleCode(tenantCode, roleCode);
        if (roleEntity == null) {
            return null;
        }
        return (RoleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)roleEntity, RoleVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void copy(RoleVo vo) {
        Validate.notNull((Object)vo, (String)"\u590d\u5236\u64cd\u4f5c\u65f6\uff0c\u89d2\u8272\u63cf\u8ff0\u4fe1\u606f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getCopyRoleCode(), (String)"\u590d\u5236\u64cd\u4f5c\u65f6\uff0c\u88ab\u590d\u5236\u89d2\u8272\u7f16\u7801\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        RoleVo roleVo = this.create(vo);
        vo.setTenantCode(roleVo.getTenantCode());
        if (!CollectionUtils.isEmpty(this.roleCopyEventListener)) {
            this.roleCopyEventListener.forEach(listener -> listener.onCopied(vo));
        }
    }

    @Transactional
    public void enable(String[] roleIds) {
        this.roleService.enable(roleIds);
        String tenantCode = TenantUtils.getTenantCode();
        this.roleVoCacheService.notifyCacheRefresh(tenantCode);
    }

    @Transactional
    public void disable(String[] roleIds) {
        this.roleService.disable(roleIds);
        String tenantCode = TenantUtils.getTenantCode();
        this.roleVoCacheService.notifyCacheRefresh(tenantCode);
    }
}

