/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.rbac.local.dto.RoleConditionDto;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.service.RoleService;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/rbac/roles"})
public class RoleController
extends BaseController {
    @Autowired
    private RoleService roleService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleController.class);

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u540d\u79f0\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\uff0c\u6216\u5219\u89d2\u8272\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u4fe1\u606f \uff08\u89d2\u8272\u540d\u79f0\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(value="\u5206\u9875\u53c2\u6570") @PageableDefault(size=50) Pageable pageable, RoleConditionDto conditions) {
        try {
            Page<RoleEntity> roles = this.roleService.findByConditions(conditions, pageable);
            return this.buildHttpResultW(roles, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findDetailsByIds"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f,\u591a\u4e2a\u4fe1\u606f")
    public ResponseModel findDetailsByIds(@RequestParam(name="ids") @ApiParam(value="\u4e3b\u952eID\uff0c\u53ef\u4ee5\u4f20\u5165\u591a\u4e2a") String[] ids) {
        try {
            if (ids == null) {
                return this.buildHttpResult();
            }
            Set<RoleEntity> roles = this.roleService.findDetailsByIds(Lists.newArrayList((Object[])ids));
            return this.buildHttpResultW(roles, new String[]{"parent"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u67e5\u8be2(\u652f\u6301\u591a\u4e2a)")
    @GetMapping(value={"/findByCodes"})
    public ResponseModel findByCode(@ApiParam(value="\u89d2\u8272\u7f16\u7801\u6570\u7ec4") @RequestParam(name="roleCodes") String[] roleCodes) {
        try {
            if (roleCodes == null) {
                return this.buildHttpResult();
            }
            String tenantCode = TenantUtils.getTenantCode();
            Set<RoleEntity> roles = this.roleService.findDetailsByCodes(tenantCode, Lists.newArrayList((Object[])roleCodes));
            return this.buildHttpResultW(roles, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

