/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.rbac.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.rbac.local.dto.RoleConditionDto;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.repository.internal.RoleRepositoryCustom;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class RoleRepositoryImpl
implements RoleRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<RoleEntity> findByConditions(RoleConditionDto conditions, Pageable pageable) {
        StringBuilder hql = new StringBuilder("from RoleEntity r where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(*) from RoleEntity r where 1 = 1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)conditions.getTenantCode())) {
            condition.append(" AND r.tenantCode = :tenantCode ");
            parameter.put("tenantCode", conditions.getTenantCode());
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getRoleName())) {
            condition.append(" AND r.roleName like CONCAT('%', :roleName, '%') ");
            parameter.put("roleName", conditions.getRoleName());
        }
        if (StringUtils.isNotBlank((CharSequence)conditions.getRoleCode())) {
            condition.append(" AND r.roleCode = :roleCode ");
            parameter.put("roleCode", conditions.getRoleCode());
        }
        if (conditions.getStatus() != null) {
            condition.append(" AND r.tstatus = :tstatus ");
            parameter.put("tstatus", conditions.getStatus());
        }
        hql.append((CharSequence)condition).append(" order by r.createTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
    }
}

